/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.mixins;

import com.llamalad7.mixinextras.sugar.Local;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.data.ResearchdAttachments;
import com.portingdeadmods.researchd.impl.research.effect.data.RecipeUnlockEffectData;
import com.portingdeadmods.researchd.impl.research.effect.data.UnlockItemEffectData;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={AbstractFurnaceBlockEntity.class})
public class AbstractFurnaceBlockEntityMixin {
    @ModifyVariable(method={"serverTick"}, at=@At(value="LOAD", target="recipeholder"), name={"recipeholder"})
    private static RecipeHolder<?> modifyRecipeHolder(RecipeHolder<?> recipeholder, @Local(argsOnly=true) Level level, @Local(argsOnly=true) AbstractFurnaceBlockEntity blockEntity) {
        UUID playerUUID;
        Player player;
        if (recipeholder != null && (player = level.getPlayerByUUID(playerUUID = (UUID)blockEntity.getData(ResearchdAttachments.PLACED_BY_UUID))) != null) {
            UnlockItemEffectData itemData = (UnlockItemEffectData)player.getData(ResearchdAttachments.ITEM_PREDICATE.get());
            RecipeUnlockEffectData recipeData = (RecipeUnlockEffectData)player.getData(ResearchdAttachments.RECIPE_PREDICATE.get());
            Recipe recipe = recipeholder.value();
            if (AbstractFurnaceBlockEntityMixin.isItemBlocked(itemData, recipe, level)) {
                Researchd.debug("Furnace Mixin", "Blocked due to item predicate.");
                return null;
            }
            if (!recipeData.isEmpty()) {
                Researchd.debug("Furnace Mixin", "RecipePredicateData: " + String.valueOf(recipeData.blockedRecipes()));
                Researchd.debug("Furnace Mixin", "RecipeHolder id: " + String.valueOf(recipeholder.id()));
                if (recipeData.contains(recipeholder)) {
                    Researchd.debug("Furnace Mixin", "Recipe for " + String.valueOf(recipeholder.value().getResultItem((HolderLookup.Provider)level.registryAccess())) + " blocked!");
                    return null;
                }
            }
        }
        return recipeholder;
    }

    private static boolean isItemBlocked(UnlockItemEffectData itemData, Recipe<?> recipe, Level level) {
        if (itemData.blockedItems().isEmpty()) {
            return false;
        }
        ItemStack result = recipe.getResultItem((HolderLookup.Provider)level.registryAccess());
        if (!result.isEmpty() && itemData.isBlocked(result)) {
            return true;
        }
        for (Ingredient ingredient : recipe.getIngredients()) {
            if (ingredient.isEmpty()) continue;
            for (ItemStack stack : ingredient.getItems()) {
                if (stack.isEmpty() || !itemData.isBlocked(stack)) continue;
                return true;
            }
        }
        return false;
    }
}

