/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.networking.team;

import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.api.team.ResearchTeam;
import com.portingdeadmods.researchd.data.ResearchdSavedData;
import com.portingdeadmods.researchd.impl.team.ResearchTeamMap;
import com.portingdeadmods.researchd.utils.researches.ResearchTeamHelper;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record RequestToJoinPayload(UUID toJoin, boolean remove) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RequestToJoinPayload> TYPE = new CustomPacketPayload.Type(Researchd.rl("request_to_join_payload"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RequestToJoinPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, RequestToJoinPayload::toJoin, (StreamCodec)ByteBufCodecs.BOOL, RequestToJoinPayload::remove, RequestToJoinPayload::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)patt0$temp;
                MinecraftServer server = sp.getServer();
                ServerLevel level = server.overworld();
                Player teamMemberPlayer = level.getPlayerByUUID(this.toJoin());
                if (teamMemberPlayer != null) {
                    ResearchTeam team = ResearchTeamHelper.getTeamByMember(teamMemberPlayer);
                    if (this.remove()) {
                        team.getSocialManager().removeReceivedInvite(sp.getUUID());
                    } else {
                        team.getSocialManager().addSentInvite(sp.getUUID());
                    }
                    ResearchdSavedData.TEAM_RESEARCH.get().setData((Level)level, (Object)((ResearchTeamMap)ResearchdSavedData.TEAM_RESEARCH.get().getData((Level)level)));
                    ResearchdSavedData.TEAM_RESEARCH.get().sync((Level)level);
                    ResearchTeamHelper.refreshPlayerManagement(team, (Level)level);
                } else {
                    sp.sendSystemMessage((Component)Component.literal((String)"The player you're trying to join does not exist!").withStyle(ChatFormatting.RED));
                }
            }
        }).exceptionally(e -> {
            Researchd.LOGGER.error("Failed to handle RequestToJoinPayload", e);
            context.disconnect((Component)Component.literal((String)("Action Failed:  " + e.getMessage())));
            return null;
        });
    }
}

