/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.pdl.config;

import com.portingdeadmods.researchd.pdl.config.PDLConfigManager;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.Nullable;

public class PDLConfig {
    private final Map<String, Value<?>> configValues;
    private final Map<String, ModConfigSpec.ConfigValue<?>> specConfigValues;
    private final ModConfig.Type type;
    private final Class<?> configClass;

    public PDLConfig(Class<?> configClass, ModConfig.Type type) {
        this.configClass = configClass;
        this.configValues = new HashMap();
        this.specConfigValues = new HashMap();
        this.type = type;
    }

    public void addConfigValue(String path, Value<?> value) {
        this.configValues.put(path, value);
    }

    public Value<?> getValue(String path) {
        return this.configValues.get(path);
    }

    public ModConfigSpec.ConfigValue<?> getSpecValue(String path) {
        return this.specConfigValues.get(path);
    }

    public ModConfig.Type getType() {
        return this.type;
    }

    public Set<String> getConfigPaths() {
        return this.configValues.keySet();
    }

    public void register(ModContainer modContainer) {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        for (String path : this.getConfigPaths()) {
            Value<?> value = this.getValue(path);
            if (value.type() == null) continue;
            builder.comment(value.comment());
            this.specConfigValues.put(path, switch (value.type().ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 1, 2 -> builder.defineInRange(path, ((Integer)value.defaultValue()).intValue(), (int)value.min(), (int)value.max());
                case 3 -> builder.defineInRange(path, ((Long)value.defaultValue()).longValue(), (long)value.min(), (long)value.max());
                case 4, 5 -> builder.defineInRange(path, ((Double)value.defaultValue()).doubleValue(), value.min(), value.max());
                case 6 -> builder.define(path, value.defaultValue());
                case 7 -> builder.define(path, ((Boolean)value.defaultValue()).booleanValue());
                case 8 -> builder.defineEnum(path, (Enum)value.defaultValue());
                case 9 -> builder.defineList(path, (List)value.defaultValue(), String::new, s -> true);
                case 10 -> throw new RuntimeException("Map NYI");
            });
        }
        ModConfigSpec spec = builder.build();
        modContainer.registerConfig(this.type, (IConfigSpec)spec);
        PDLConfigManager.CONFIGS.put((IConfigSpec)spec, this);
        PDLConfigManager.CONFIGS_BY_CLASS.put(this.configClass, this);
    }

    public record Value<T>(Field field, @Nullable Type type, T defaultValue, String key, String category, String name, String comment, double min, double max) {

        public static enum Type {
            BYTE(true),
            SHORT(true),
            INTEGER(true),
            LONG(true),
            FLOAT(true),
            DOUBLE(true),
            STRING(false),
            BOOLEAN(false),
            ENUM(false),
            LIST(false),
            MAP(false);

            private final boolean number;

            private Type(boolean number) {
                this.number = number;
            }

            public boolean isNumber() {
                return this.number;
            }
        }
    }
}

