/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.pdl.config;

import com.portingdeadmods.portingdeadlibs.PortingDeadLibs;
import com.portingdeadmods.researchd.pdl.config.ConfigValue;
import com.portingdeadmods.researchd.pdl.config.PDLConfig;
import com.portingdeadmods.researchd.pdl.config.PDLConfigManager;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="researchd")
public class PDLConfigHelper {
    public static PDLConfig registerConfig(Class<?> configClass, ModConfig.Type configType) {
        PDLConfig config = new PDLConfig(configClass, configType);
        for (Field field : configClass.getFields()) {
            Object defaultValue;
            String key;
            if (!field.isAnnotationPresent(ConfigValue.class)) continue;
            if (!Modifier.isStatic(field.getModifiers())) {
                PortingDeadLibs.LOGGER.error("Non-static field ({}) in class {} annotated with @ConfigValue", (Object)field.getName(), (Object)configClass.getName());
                continue;
            }
            if (Modifier.isFinal(field.getModifiers())) {
                PortingDeadLibs.LOGGER.error("Field ({}) in class {} annotated with @ConfigValue is final", (Object)field.getName(), (Object)configClass.getName());
                continue;
            }
            ConfigValue annotation = field.getAnnotation(ConfigValue.class);
            Object category = annotation.category();
            if (!((String)category).isEmpty()) {
                category = (String)category + ".";
            }
            if ((key = annotation.key()).isEmpty()) {
                key = PDLConfigHelper.camelToSnake(field.getName());
            }
            String path = (String)category + key;
            PDLConfig.Value.Type type = PDLConfigHelper.classToConfigType(field.getType());
            if (type == null) {
                PortingDeadLibs.LOGGER.error("Field ({}) in class {}, annotated with @ConfigValue has invalid type for config. Supported types are: byte, short, int, long, float, double, String, boolean, List, Map - received type {} instead", new Object[]{field.getName(), configClass.getName(), field.getType().getName()});
                continue;
            }
            try {
                defaultValue = field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            double min = 0.0;
            double max = 0.0;
            if (type.isNumber()) {
                if (annotation.range().length > 2) {
                    PortingDeadLibs.LOGGER.error("Field ({}) in class {}, annotated with @ConfigValue is a number but has an invalid range. Range array can't be bigger than 2 elements.", (Object)field.getName(), (Object)configClass.getName());
                    continue;
                }
                if (annotation.range().length == 1) {
                    max = annotation.range()[0];
                } else if (annotation.range().length == 2) {
                    min = annotation.range()[0];
                    max = annotation.range()[1];
                }
            }
            PDLConfig.Value<Object> value = new PDLConfig.Value<Object>(field, type, defaultValue, key, annotation.category(), annotation.name(), annotation.comment(), min, max);
            config.addConfigValue(path, value);
        }
        return config;
    }

    public static void generateConfigNames(Class<?> configClass, String modid, BiConsumer<String, String> addTranslationFunction) {
        PDLConfig config = PDLConfigManager.CONFIGS_BY_CLASS.get(configClass);
        HashSet<String> categories = new HashSet<String>();
        for (String path : config.getConfigPaths()) {
            PDLConfig.Value<?> value = config.getValue(path);
            String category = value.category();
            if (!category.isEmpty() && !categories.contains(category)) {
                String categoryName = Character.toUpperCase(category.charAt(0)) + category.substring(1);
                addTranslationFunction.accept(modid + ".configuration." + category, categoryName);
                categories.add(category);
            }
            addTranslationFunction.accept(modid + ".configuration." + value.key(), value.name());
        }
    }

    private static <T> @Nullable PDLConfig.Value.Type classToConfigType(Class<T> type) {
        if (type == Byte.TYPE) {
            return PDLConfig.Value.Type.BYTE;
        }
        if (type == Short.TYPE) {
            return PDLConfig.Value.Type.SHORT;
        }
        if (type == Integer.TYPE) {
            return PDLConfig.Value.Type.INTEGER;
        }
        if (type == Long.TYPE) {
            return PDLConfig.Value.Type.LONG;
        }
        if (type == Float.TYPE) {
            return PDLConfig.Value.Type.FLOAT;
        }
        if (type == Double.TYPE) {
            return PDLConfig.Value.Type.DOUBLE;
        }
        if (type == String.class) {
            return PDLConfig.Value.Type.STRING;
        }
        if (type == Boolean.TYPE) {
            return PDLConfig.Value.Type.BOOLEAN;
        }
        if (List.class.isAssignableFrom(type)) {
            return PDLConfig.Value.Type.LIST;
        }
        if (Map.class.isAssignableFrom(type)) {
            return PDLConfig.Value.Type.MAP;
        }
        if (Enum.class.isAssignableFrom(type)) {
            return PDLConfig.Value.Type.ENUM;
        }
        return null;
    }

    @SubscribeEvent
    static void onConfigReloaded(ModConfigEvent event) {
        PDLConfig config = PDLConfigManager.CONFIGS.get(event.getConfig().getSpec());
        for (String path : config.getConfigPaths()) {
            PDLConfig.Value<?> value = config.getValue(path);
            Field field = value.field();
            PDLConfigHelper.setFieldValue(field, config.getSpecValue(path).get());
        }
    }

    public static String camelToSnake(String str) {
        StringBuilder result = new StringBuilder();
        char c = str.charAt(0);
        result.append(Character.toLowerCase(c));
        for (int i = 1; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (Character.isUpperCase(ch)) {
                result.append('_');
                result.append(Character.toLowerCase(ch));
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setFieldValue(Field field, Object value) {
        try {
            Class<?> type = field.getType();
            if (type.isPrimitive()) {
                if (type == Integer.TYPE) {
                    field.setInt(null, ((Number)value).intValue());
                    return;
                } else if (type == Boolean.TYPE) {
                    field.setBoolean(null, (Boolean)value);
                    return;
                } else if (type == Long.TYPE) {
                    field.setLong(null, ((Number)value).longValue());
                    return;
                } else if (type == Double.TYPE) {
                    field.setDouble(null, ((Number)value).doubleValue());
                    return;
                } else if (type == Float.TYPE) {
                    field.setFloat(null, ((Number)value).floatValue());
                    return;
                } else if (type == Short.TYPE) {
                    field.setShort(null, ((Number)value).shortValue());
                    return;
                } else if (type == Byte.TYPE) {
                    field.setByte(null, ((Number)value).byteValue());
                    return;
                } else {
                    if (type != Character.TYPE) throw new IllegalArgumentException("Unsupported primitive type: " + String.valueOf(type));
                    field.setChar(null, ((Character)value).charValue());
                }
                return;
            } else {
                field.set(null, value);
            }
            return;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

