/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.resources;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.portingdeadmods.portingdeadlibs.utils.Result;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.api.research.packs.ResearchPack;
import com.portingdeadmods.researchd.resources.contents.ResearchdResearchPacks;
import com.portingdeadmods.researchd.resources.contents.ResearchdResearches;
import com.portingdeadmods.researchd.utils.researches.ReloadableRegistryManager;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.minecraft.SharedConstants;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;

public class ExampleDatapack {
    public static Result<Path, Exception> createExample(Path datapacksDir, String packName, String packDescription) {
        Path exampleDataPackDir = datapacksDir.resolve(packName);
        try {
            if (Files.notExists(exampleDataPackDir, new LinkOption[0])) {
                Files.createDirectories(exampleDataPackDir, new FileAttribute[0]);
                Path packFile = exampleDataPackDir.resolve("pack.mcmeta");
                Files.writeString(packFile, (CharSequence)ExampleDatapack.getPackFile(packDescription), new OpenOption[0]);
                Path packContentRootDir = exampleDataPackDir.resolve("data").resolve("rd_examples");
                Path packResearchdRegistriesDir = packContentRootDir.resolve("researchd");
                Files.createDirectories(packResearchdRegistriesDir, new FileAttribute[0]);
                Path packResearchesDir = packResearchdRegistriesDir.resolve("research");
                Files.createDirectory(packResearchesDir, new FileAttribute[0]);
                ExampleDatapack.createResearches(packResearchesDir);
                Path packResearchPacksDir = packResearchdRegistriesDir.resolve("research_pack");
                Files.createDirectory(packResearchPacksDir, new FileAttribute[0]);
                ExampleDatapack.createResearchPacks(packResearchPacksDir);
                return Result.ok((Object)exampleDataPackDir);
            }
            return Result.err((String)"Example Datapack already exists");
        }
        catch (IOException e) {
            Researchd.LOGGER.error("Encountered error while creating files and directories for example datapack", (Throwable)e);
            return Result.err((String)"File/Directory creation failed");
        }
    }

    private static String getPackFile(String desc) {
        return "{\n  \"pack\": {\n    \"description\": {\n      \"text\": \"%s\"\n    },\n    \"pack_format\": %d\n  }\n}\n".formatted(desc, SharedConstants.getCurrentVersion().getPackVersion(PackType.SERVER_DATA));
    }

    private static void createResearches(Path researchDir) {
        ResearchdResearches researches = new ResearchdResearches("rd_examples");
        researches.buildExampleDatapack();
        for (Map.Entry<ResourceKey<Research>, Research> entry : researches.getContents().entrySet()) {
            Codec<Research> codec = Research.CODEC;
            ExampleDatapack.writeToFile(researchDir, (DataResult<JsonElement>)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()), entry.getKey().location());
        }
    }

    private static void createResearchPacks(Path researchDir) {
        ResearchdResearchPacks packs = new ResearchdResearchPacks("rd_examples");
        packs.buildExampleDatapack();
        for (Map.Entry<ResourceKey<ResearchPack>, ResearchPack> entry : packs.getContents().entrySet()) {
            Codec<ResearchPack> codec = ResearchPack.CODEC;
            ExampleDatapack.writeToFile(researchDir, (DataResult<JsonElement>)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()), entry.getKey().location());
        }
    }

    private static void writeToFile(Path researchDir, DataResult<JsonElement> result, ResourceLocation location) {
        result.ifSuccess(json -> {
            try (FileWriter writer = new FileWriter(researchDir.resolve(location.getPath() + ".json").toFile());){
                ReloadableRegistryManager.GSON.toJson(json, (Appendable)writer);
            }
            catch (IOException e) {
                Researchd.LOGGER.error("Failed to write json to file", (Throwable)e);
            }
        });
    }
}

