/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.resources;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import org.jetbrains.annotations.NotNull;

public record ResearchdExamplesSource(String packId, PackType packType, Pack.Position packPosition, PackSource source, PackResources packResources) implements RepositorySource
{
    public ResearchdExamplesSource(String packId, PackType packType, Pack.Position packPosition, PackResources packResources) {
        this(packId, packType, packPosition, PackSource.FEATURE, packResources);
    }

    public void loadPacks(@NotNull Consumer<Pack> onLoad) {
        PackLocationInfo locationInfo = new PackLocationInfo(this.packId, (Component)Component.literal((String)this.packId), this.source, Optional.empty());
        PackSelectionConfig selectionConfig = new PackSelectionConfig(this.packType == PackType.CLIENT_RESOURCES, this.packPosition, false);
        Pack.ResourcesSupplier resourcesSupplier = new Pack.ResourcesSupplier(){

            @NotNull
            public PackResources openPrimary(@NotNull PackLocationInfo packLocationInfo) {
                return ResearchdExamplesSource.this.packResources;
            }

            @NotNull
            public PackResources openFull(@NotNull PackLocationInfo packLocationInfo, @NotNull Pack.Metadata metadata) {
                return ResearchdExamplesSource.this.packResources;
            }
        };
        onLoad.accept(Pack.readMetaAndCreate((PackLocationInfo)locationInfo, (Pack.ResourcesSupplier)resourcesSupplier, (PackType)this.packType, (PackSelectionConfig)selectionConfig));
    }
}

