/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.resources.contents;

import com.portingdeadmods.researchd.ResearchdRegistries;
import com.portingdeadmods.researchd.resources.contents.ResearchdResearchPacks;
import com.portingdeadmods.researchd.resources.contents.ResearchdResearches;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class ResearchdLang {
    private final Map<String, String> translations;
    private final String modid;

    public ResearchdLang(String modid) {
        this.modid = modid;
        this.translations = new HashMap<String, String>();
    }

    public void build() {
        this.addResearch(ResearchdResearches.COBBLESTONE_LOC, "Wonder what type of stone it is...");
        this.addResearch(ResearchdResearches.OVERWORLD_PACK_LOC, "The start of something");
        this.addResearch(ResearchdResearches.NETHER_LOC, "From below...");
        this.addResearch(ResearchdResearches.END_LOC, "The start... of something?");
        this.addResearch(ResearchdResearches.BEACON_LOC, "The beam looks funny");
        this.addResearch(ResearchdResearches.END_CRYSTAL_LOC, "If you look at it, it spins...");
        this.addResearch(ResearchdResearches.STONE_LOC, "Nah it's just stone");
        this.addResearch(ResearchdResearches.DIFFERENT_ROCKS_LOC, "It's... just stone?");
        this.addResearchPackName(ResearchdResearchPacks.END_PACK_LOC, "End Research Pack");
        this.addResearchPackName(ResearchdResearchPacks.NETHER_PACK_LOC, "Nether Research Pack");
        this.addResearchPackName(ResearchdResearchPacks.OVERWORLD_PACK_LOC, "Overworld Research Pack");
    }

    private void addResearch(ResourceLocation key, String name) {
        this.add(ResearchdRegistries.RESEARCH_KEY.location().getPath() + "." + key.getNamespace() + "." + key.getPath() + "_name", name);
    }

    private void addResearchMethod(ResourceLocation key, String name) {
        this.add("research_method." + key.getNamespace() + "." + key.getPath(), name);
    }

    private void addResearchPackName(ResourceLocation key, String name) {
        this.add("research_pack." + key.toString().replace(':', '.') + "_name", name);
    }

    private void addResearchPackDescription(ResourceLocation key, String name) {
        this.add("research_pack" + key.toString().replace(':', '.') + "_desc", name);
    }

    private void add(String key, String name) {
        this.translations.put(key, name);
    }

    public Map<String, String> getContents() {
        return this.translations;
    }
}

