/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.resources.contents;

import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.ResearchdRegistries;
import com.portingdeadmods.researchd.api.research.packs.ResearchPack;
import com.portingdeadmods.researchd.data.components.ResearchPackComponent;
import com.portingdeadmods.researchd.impl.research.ResearchPackImpl;
import com.portingdeadmods.researchd.registries.ResearchdDataComponents;
import com.portingdeadmods.researchd.registries.ResearchdItems;
import com.portingdeadmods.researchd.resources.ResearchdDatagenProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ResearchdResearchPacks
implements ResearchdDatagenProvider<ResearchPack> {
    public static final ResourceLocation OVERWORLD_PACK_LOC = Researchd.rl("overworld");
    public static final ResourceLocation NETHER_PACK_LOC = Researchd.rl("nether");
    public static final ResourceLocation END_PACK_LOC = Researchd.rl("end");
    private final String modid;
    private final Map<ResourceKey<ResearchPack>, ResearchPack> researchPacks;

    public ResearchdResearchPacks(String modid) {
        this.modid = modid;
        this.researchPacks = new HashMap<ResourceKey<ResearchPack>, ResearchPack>();
    }

    @Override
    public void build() {
        this.researchPack("overworld", builder -> builder.literalName("Overworld Pack").sortingValue(1).color(20, 240, 20));
        this.researchPack("nether", builder -> builder.literalName("Nether Pack").sortingValue(2).color(160, 20, 20));
        this.researchPack("end", builder -> builder.literalName("End Pack").sortingValue(3).color(63, 36, 83));
    }

    public void buildExampleDatapack() {
        this.researchPack("test_pack", builder -> builder.sortingValue(1).color(120, 150, 90));
    }

    protected ResourceKey<ResearchPack> researchPack(String name, UnaryOperator<ResearchPackImpl.Builder> builder) {
        ResourceKey<ResearchPack> key = this.key(name);
        this.researchPacks.put(key, ((ResearchPackImpl.Builder)builder.apply(ResearchPackImpl.builder())).build());
        return key;
    }

    protected ResourceKey<ResearchPack> key(String name) {
        return ResourceKey.create(ResearchdRegistries.RESEARCH_PACK_KEY, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)name));
    }

    public static ItemStack asStack(ResourceKey<ResearchPack> key, int count) {
        ItemStack pack = ResearchdItems.RESEARCH_PACK.toStack();
        pack.set(ResearchdDataComponents.RESEARCH_PACK.get(), (Object)new ResearchPackComponent(Optional.of(key)));
        pack.setCount(count);
        return pack;
    }

    public static ItemStack asStack(ResourceKey<ResearchPack> key) {
        return ResearchdResearchPacks.asStack(key, 1);
    }

    public static ItemStack asStack(ResourceLocation key) {
        return ResearchdResearchPacks.asStack((ResourceKey<ResearchPack>)ResourceKey.create(ResearchdRegistries.RESEARCH_PACK_KEY, (ResourceLocation)key), 1);
    }

    @Override
    public Map<ResourceKey<ResearchPack>, ResearchPack> getContents() {
        return this.researchPacks;
    }
}

