/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.resources.contents;

import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.ResearchdRegistries;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.api.research.effects.ResearchEffect;
import com.portingdeadmods.researchd.api.research.methods.ResearchMethod;
import com.portingdeadmods.researchd.api.research.packs.ResearchPack;
import com.portingdeadmods.researchd.impl.research.SimpleResearch;
import com.portingdeadmods.researchd.impl.research.effect.AndResearchEffect;
import com.portingdeadmods.researchd.impl.research.effect.DimensionUnlockEffect;
import com.portingdeadmods.researchd.impl.research.effect.RecipeUnlockEffect;
import com.portingdeadmods.researchd.impl.research.effect.UnlockItemEffect;
import com.portingdeadmods.researchd.impl.research.method.AndResearchMethod;
import com.portingdeadmods.researchd.impl.research.method.CheckItemPresenceResearchMethod;
import com.portingdeadmods.researchd.impl.research.method.ConsumeItemResearchMethod;
import com.portingdeadmods.researchd.impl.research.method.ConsumePackResearchMethod;
import com.portingdeadmods.researchd.impl.research.method.OrResearchMethod;
import com.portingdeadmods.researchd.registries.ResearchdItems;
import com.portingdeadmods.researchd.resources.ResearchdDatagenProvider;
import com.portingdeadmods.researchd.resources.contents.ResearchdResearchPacks;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ResearchdResearches
implements ResearchdDatagenProvider<Research> {
    public static final ResourceLocation COBBLESTONE_LOC = Researchd.rl("cobblestone");
    public static final ResourceLocation OVERWORLD_PACK_LOC = Researchd.rl("overworld_pack");
    public static final ResourceLocation NETHER_LOC = Researchd.rl("nether");
    public static final ResourceLocation END_LOC = Researchd.rl("the_end");
    public static final ResourceLocation END_CRYSTAL_LOC = Researchd.rl("end_crystal");
    public static final ResourceLocation BEACON_LOC = Researchd.rl("beacon");
    public static final ResourceLocation STONE_LOC = Researchd.rl("stone");
    public static final ResourceLocation DIFFERENT_ROCKS_LOC = Researchd.rl("different_rocks");
    private final String modid;
    private final Map<ResourceKey<Research>, Research> researches;

    public ResearchdResearches(String modid) {
        this.modid = modid;
        this.researches = new HashMap<ResourceKey<Research>, Research>();
    }

    @Override
    public void build() {
        ResourceKey<Research> cobblestone = this.simpleResearch("cobblestone", builder -> builder.icon(Items.COBBLESTONE).method(this.consumeItem((ItemLike)Items.COBBLESTONE, 4)).effect(this.and(this.unlockRecipe(this.mcLoc("stone_pickaxe")), this.unlockRecipe(this.mcLoc("furnace")))));
        ResourceKey<Research> stone = this.simpleResearch("stone", builder -> builder.icon(Items.STONE).method(this.hasItem((ItemLike)Items.COBBLESTONE, 64)).parents(cobblestone).effect(this.and(this.unlockItem((ItemLike)Items.STONE), this.unlockItem((ItemLike)Items.STONE_BRICKS), this.unlockItem((ItemLike)Items.STONE_BRICK_SLAB), this.unlockItem((ItemLike)Items.STONE_BRICK_STAIRS), this.unlockItem((ItemLike)Items.SMOOTH_STONE), this.unlockItem((ItemLike)Items.STONECUTTER))));
        ResourceKey<Research> different_rocks = this.simpleResearch("different_rocks", builder -> builder.icon(Items.DIORITE).method(this.and(this.or(this.hasItem((ItemLike)Items.DIORITE, 16), this.hasItem((ItemLike)Items.ANDESITE, 16), this.hasItem((ItemLike)Items.GRANITE, 16)), this.hasItem((ItemLike)Items.STONE, 64))).parents(stone).effect(this.and(this.unlockItem((ItemLike)Items.STONE), this.unlockItem((ItemLike)Items.STONE_BRICKS), this.unlockItem((ItemLike)Items.STONE_BRICK_SLAB), this.unlockItem((ItemLike)Items.STONE_BRICK_STAIRS), this.unlockItem((ItemLike)Items.SMOOTH_STONE), this.unlockItem((ItemLike)Items.STONECUTTER))));
        ResourceKey<Research> overworldPack = this.simpleResearch("overworld_pack", builder -> builder.icon(ResearchdItems.RESEARCH_LAB.asItem()).parents(cobblestone).method(this.consumeItem((ItemLike)Items.IRON_INGOT, 4)).effect(this.and(this.unlockRecipe(this.modLoc("research_lab")), this.unlockRecipe(this.modLoc("overworld_pack")))));
        ResourceKey<Research> nether = this.simpleResearch("nether", builder -> builder.icon(Items.NETHERRACK).parents(overworldPack).method(this.consumePack(25, 100, this.pack(ResearchdResearchPacks.OVERWORLD_PACK_LOC))).effect(this.and(this.unlockRecipe(this.modLoc("nether_pack")), this.unlockDimension(this.mcLoc("the_nether"), DimensionUnlockEffect.NETHER_SPRITE))));
        ResourceKey<Research> cake = this.simpleResearch("cake", builder -> builder.icon(Items.CAKE).parents(nether).method(this.hasItem((ItemLike)Items.CAKE, 1)).effect(this.unlockItem((ItemLike)Items.CAKE)));
        ResourceKey<Research> end = this.simpleResearch("the_end", builder -> builder.icon(Items.END_STONE).parents(nether).method(this.consumePack(100, 200, this.pack(ResearchdResearchPacks.OVERWORLD_PACK_LOC), this.pack(ResearchdResearchPacks.NETHER_PACK_LOC))).effect(this.and(this.unlockRecipe(this.modLoc("end_pack")), this.unlockDimension(this.mcLoc("the_end"), DimensionUnlockEffect.END_SPRITE))));
        this.simpleResearch("end_crystal", builder -> builder.icon(Items.END_CRYSTAL).parents(end).method(this.consumePack(250, 200, this.pack(ResearchdResearchPacks.OVERWORLD_PACK_LOC), this.pack(ResearchdResearchPacks.NETHER_PACK_LOC), this.pack(ResearchdResearchPacks.END_PACK_LOC))).effect(this.and(this.unlockRecipe(this.mcLoc("end_crystal")))));
        this.simpleResearch("beacon", builder -> builder.icon(Items.BEACON).parents(end).method(this.consumePack(250, 200, this.pack(ResearchdResearchPacks.OVERWORLD_PACK_LOC), this.pack(ResearchdResearchPacks.NETHER_PACK_LOC), this.pack(ResearchdResearchPacks.END_PACK_LOC))).effect(this.and(this.unlockRecipe(this.mcLoc("beacon")))));
    }

    public void buildExampleDatapack() {
        ResourceKey<Research> wood = this.simpleResearch("wood", builder -> builder.literalName("Wood").literalDescription("Boxing match").icon(Items.OAK_LOG).method(this.and(this.consumeItem((ItemLike)Items.DIRT, 8), this.consumeItem((ItemLike)Items.WHEAT_SEEDS, 1))).effect(this.unlockRecipe(this.mcLoc("oak_planks"))));
        ResourceKey<Research> iron = this.simpleResearch("iron", builder -> builder.literalName("Iron").literalDescription("Acquire software").icon(Items.IRON_INGOT).parents(wood).method(this.or(this.consumeItem((ItemLike)Items.FURNACE, 1), this.consumeItem((ItemLike)Items.COBBLESTONE, 8))).effect(this.unlockRecipe(this.mcLoc("iron_pickaxe"))));
        this.simpleResearch("nether_dim", builder -> builder.literalName("Nether").literalDescription("The second dimension").icon(Items.NETHERRACK).parents(iron).method(this.consumePack(50, 200, this.pack(this.modLoc("test_pack")))).effect(this.and(this.unlockRecipe(this.mcLoc("netherite_ingot")), this.unlockRecipe(this.mcLoc("gold_block")))));
    }

    @Override
    public Map<ResourceKey<Research>, Research> getContents() {
        return this.researches;
    }

    @NotNull
    protected ResourceLocation mcLoc(String path) {
        return ResourceLocation.withDefaultNamespace((String)path);
    }

    @NotNull
    protected ResourceLocation modLoc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path);
    }

    @NotNull
    protected ResourceLocation loc(String namespace, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
    }

    @NotNull
    protected DimensionUnlockEffect unlockDimension(ResourceLocation location, ResourceLocation sprite) {
        return new DimensionUnlockEffect(location, sprite);
    }

    @NotNull
    protected UnlockItemEffect unlockItem(ItemLike item) {
        return new UnlockItemEffect(item.asItem());
    }

    @SafeVarargs
    @NotNull
    protected final ConsumePackResearchMethod consumePack(int count, int duration, ResourceKey<ResearchPack> ... packs) {
        return new ConsumePackResearchMethod(Arrays.asList(packs), count, duration);
    }

    @NotNull
    protected RecipeUnlockEffect unlockRecipe(ResourceLocation location) {
        return new RecipeUnlockEffect(location);
    }

    @NotNull
    protected ConsumeItemResearchMethod consumeItem(ItemLike item, int count) {
        return new ConsumeItemResearchMethod(Ingredient.of((ItemLike[])new ItemLike[]{item}), count);
    }

    @NotNull
    protected CheckItemPresenceResearchMethod hasItem(ItemLike item, int count) {
        return new CheckItemPresenceResearchMethod(Ingredient.of((ItemLike[])new ItemLike[]{item}), count);
    }

    protected ResourceKey<Research> key(String name) {
        return ResourceKey.create(ResearchdRegistries.RESEARCH_KEY, (ResourceLocation)this.modLoc(name));
    }

    protected ResourceKey<ResearchPack> pack(ResourceLocation location) {
        return ResourceKey.create(ResearchdRegistries.RESEARCH_PACK_KEY, (ResourceLocation)location);
    }

    protected ResearchMethod and(ResearchMethod ... methods) {
        return new AndResearchMethod(List.of(methods));
    }

    protected ResearchMethod or(ResearchMethod ... methods) {
        return new OrResearchMethod(List.of(methods));
    }

    protected ResearchEffect and(ResearchEffect ... methods) {
        return new AndResearchEffect(List.of(methods));
    }

    protected ResourceKey<Research> simpleResearch(String name, UnaryOperator<SimpleResearch.Builder> builder) {
        ResourceKey<Research> key = this.key(name);
        this.researches.put(key, ((SimpleResearch.Builder)builder.apply(SimpleResearch.builder())).build());
        return key;
    }
}

