/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.utils.researches;

import com.portingdeadmods.portingdeadlibs.utils.UniqueArray;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.api.research.ResearchInstance;
import com.portingdeadmods.researchd.api.research.ResearchStatus;
import com.portingdeadmods.researchd.api.research.effects.ResearchEffect;
import com.portingdeadmods.researchd.api.research.effects.ResearchEffectData;
import com.portingdeadmods.researchd.api.research.effects.ResearchEffectList;
import com.portingdeadmods.researchd.api.research.packs.ResearchPack;
import com.portingdeadmods.researchd.api.team.ResearchTeam;
import com.portingdeadmods.researchd.data.ResearchdSavedData;
import com.portingdeadmods.researchd.impl.research.effect.data.DimensionUnlockEffectData;
import com.portingdeadmods.researchd.impl.research.effect.data.RecipeUnlockEffectData;
import com.portingdeadmods.researchd.impl.research.effect.data.UnlockItemEffectData;
import com.portingdeadmods.researchd.impl.team.ResearchTeamMap;
import com.portingdeadmods.researchd.impl.team.SimpleResearchTeam;
import com.portingdeadmods.researchd.utils.TimeDifference;
import com.portingdeadmods.researchd.utils.researches.ResearchdManagers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.Nullable;

public final class ResearchHelperCommon {
    public static Map<ResourceKey<Research>, Research> getLevelResearches(Level level) {
        return ResearchdManagers.getResearchesManager(level).getLookup();
    }

    private static <T extends ResearchEffect> void _collectEffects(ResearchEffect effect, Collection<T> effects) {
        if (effect instanceof ResearchEffectList) {
            ResearchEffectList list = (ResearchEffectList)effect;
            for (ResearchEffect subEffect : list.effects()) {
                ResearchHelperCommon._collectEffects(subEffect, effects);
            }
        } else {
            effects.add(effect);
        }
    }

    public static <T extends ResearchEffect> Collection<T> getResearchEffects(Class<T> clazz, Level level) {
        UniqueArray effects = new UniqueArray();
        for (Research research : ResearchHelperCommon.getLevelResearches(level).values()) {
            ResearchEffect effect = research.researchEffect();
            ResearchHelperCommon._collectEffects(effect, effects);
        }
        return new ArrayList<ResearchEffect>(effects.stream().filter(clazz::isInstance).toList());
    }

    public static List<ResearchInstance> getRecentResearches(ResearchTeam team) {
        Collection<ResearchInstance> researchInstances = team.getResearches().values();
        return researchInstances.stream().filter(r -> r.getResearchStatus() == ResearchStatus.RESEARCHED).sorted(Comparator.comparingLong(ResearchInstance::getResearchedTime)).toList();
    }

    public static Research getResearch(ResourceKey<Research> key, Level level) {
        return ResearchHelperCommon.getLevelResearches(level).get(key);
    }

    @Nullable
    public static ResearchInstance getInstanceByResearch(Set<ResearchInstance> researches, ResourceKey<Research> key) {
        for (ResearchInstance instance : researches) {
            if (!instance.is(key)) continue;
            return instance;
        }
        return null;
    }

    public static List<ResearchEffectData<?>> getResearchEffectData(ServerPlayer serverPlayer) {
        MinecraftServer server = serverPlayer.server;
        ServerLevel level = server.overworld();
        UniqueArray effData = new UniqueArray();
        for (Map.Entry entry : NeoForgeRegistries.ATTACHMENT_TYPES.entrySet()) {
            Object data = serverPlayer.getData((AttachmentType)entry.getValue());
            if (!(data instanceof ResearchEffectData)) continue;
            ResearchEffectData effectData = (ResearchEffectData)data;
            effData.add(effectData);
        }
        return effData.stream().sorted(Comparator.comparing(a -> a.getClass().getName())).toList();
    }

    public static Map<ResourceKey<ResearchPack>, ResearchPack> getResearchPacks(Level level) {
        return ResearchdManagers.getResearchPacksManager(level).getLookup();
    }

    public static List<ResourceKey<ResearchPack>> getResearchPackKeys(Level level) {
        Map<ResourceKey<ResearchPack>, ResearchPack> lookup = ResearchdManagers.getResearchPacksManager(level).getLookup();
        return lookup.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((ResearchPack)entry.getValue()).sortingValue())).map(Map.Entry::getKey).toList();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void refreshResearches(ServerPlayer player) {
        MinecraftServer server = player.server;
        ServerLevel level = server.overworld();
        ResearchTeamMap researchData = (ResearchTeamMap)ResearchdSavedData.TEAM_RESEARCH.get().getData((Level)level);
        SimpleResearchTeam team = researchData.getTeamByMember(player.getUUID());
        for (Map.Entry entry : NeoForgeRegistries.ATTACHMENT_TYPES.entrySet()) {
            ResourceLocation blockedItems;
            ResourceLocation rec;
            ResourceKey dim;
            Record record;
            Object data = player.getData((AttachmentType)entry.getValue());
            if (!(data instanceof ResearchEffectData)) continue;
            ResearchEffectData effectData = (ResearchEffectData)data;
            player.setData((AttachmentType)entry.getValue(), effectData.getDefault((Level)level));
            Researchd.debug("Effect Data", "Refreshing " + data.getClass().getSimpleName() + ": ");
            Iterator iterator = effectData.getDefault((Level)level);
            if (iterator instanceof DimensionUnlockEffectData) {
                record = (DimensionUnlockEffectData)((Object)iterator);
                try {
                    UniqueArray<ResourceKey<DimensionType>> uniqueArray;
                    UniqueArray<ResourceKey<DimensionType>> blockedDimensions = uniqueArray = ((DimensionUnlockEffectData)record).blockedDimensions();
                    iterator = blockedDimensions.iterator();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                while (iterator.hasNext()) {
                    dim = (ResourceKey)iterator.next();
                    Researchd.debug("Effect Data", " - " + String.valueOf(dim));
                }
            }
            if ((iterator = effectData.getDefault((Level)level)) instanceof RecipeUnlockEffectData) {
                record = (RecipeUnlockEffectData)((Object)iterator);
                {
                    ResourceKey blockedRecipes = dim = ((RecipeUnlockEffectData)record).blockedRecipes();
                    iterator = blockedRecipes.iterator();
                }
                while (iterator.hasNext()) {
                    rec = (ResourceLocation)iterator.next();
                    Researchd.debug("Effect Data", " - " + String.valueOf(rec));
                }
            }
            if (!((iterator = effectData.getDefault((Level)level)) instanceof UnlockItemEffectData)) continue;
            record = (UnlockItemEffectData)((Object)iterator);
            {
                blockedItems = rec = ((UnlockItemEffectData)record).blockedItems();
            }
            for (ResourceKey item : blockedItems) {
                Researchd.debug("Effect Data", " - " + String.valueOf(item.location()));
            }
        }
        Iterator<Object> iterator = team.getResearches().values().iterator();
        while (iterator.hasNext()) {
            ResearchInstance res = (ResearchInstance)iterator.next();
            if (res.getResearchStatus() != ResearchStatus.RESEARCHED) continue;
            ResearchEffect effect = res.lookup((Level)level).researchEffect();
            effect.onUnlock((Level)level, (Player)player, res.getKey());
        }
        return;
    }

    public static String getResearchCompletionTime(long teamCreationTime, long time) {
        return new TimeDifference(teamCreationTime, time).getFormatted();
    }

    public static ResearchPack getResearchPack(ResourceKey<ResearchPack> key, Level level) {
        return ResearchdManagers.getResearchPacksManager(level).getLookup().get(key);
    }
}

