/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.utils.researches;

import com.portingdeadmods.portingdeadlibs.cache.AllPlayersCache;
import com.portingdeadmods.portingdeadlibs.utils.PlayerUtils;
import com.portingdeadmods.researchd.api.research.GlobalResearch;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.api.research.ResearchInstance;
import com.portingdeadmods.researchd.api.research.ResearchStatus;
import com.portingdeadmods.researchd.api.team.ResearchTeam;
import com.portingdeadmods.researchd.api.team.ResearchTeamRole;
import com.portingdeadmods.researchd.api.team.TeamMember;
import com.portingdeadmods.researchd.cache.CommonResearchCache;
import com.portingdeadmods.researchd.data.ResearchdSavedData;
import com.portingdeadmods.researchd.impl.ResearchProgress;
import com.portingdeadmods.researchd.impl.team.ResearchTeamMap;
import com.portingdeadmods.researchd.impl.team.SimpleResearchTeam;
import com.portingdeadmods.researchd.networking.cache.ClearGraphCachePayload;
import com.portingdeadmods.researchd.networking.team.RefreshPlayerManagementPayload;
import com.portingdeadmods.researchd.networking.team.RefreshResearchesPayload;
import com.portingdeadmods.researchd.translations.ResearchdTranslations;
import com.portingdeadmods.researchd.utils.researches.ResearchHelperCommon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public final class ResearchTeamHelper {
    @NotNull
    public static ResearchTeam getTeamByMember(Player player) {
        UUID uuid = player.getUUID();
        return ResearchTeamHelper.getTeamByMember(player.level(), uuid);
    }

    @NotNull
    public static ResearchTeam getTeamByMember(Level level, UUID uuid) {
        ResearchTeamMap map = (ResearchTeamMap)ResearchdSavedData.TEAM_RESEARCH.get().getData(level);
        return map.getTeamByMemberOrThrow(uuid);
    }

    public static void removeMember(ServerPlayer player) {
        UUID uuid = player.getUUID();
        ResearchTeamMap savedData = (ResearchTeamMap)ResearchdSavedData.TEAM_RESEARCH.get().getData(player.level());
        SimpleResearchTeam team = savedData.getTeamByMember(uuid);
        if (team != null) {
            team.removeMember(uuid);
        }
        ResearchdSavedData.TEAM_RESEARCH.get().setData(player.level(), (Object)savedData);
    }

    public static int getPermissionLevel(Player player) {
        SimpleResearchTeam team = ((ResearchTeamMap)ResearchdSavedData.TEAM_RESEARCH.get().getData(player.level())).getTeamByMember(player.getUUID());
        if (team == null) {
            return -1;
        }
        return team.getMember(player.getUUID()).role().getPermissionLevel();
    }

    public static int getPermissionLevel(UUID player, Level level) {
        SimpleResearchTeam team = ((ResearchTeamMap)ResearchdSavedData.TEAM_RESEARCH.get().getData(level)).getTeamByMember(player);
        if (team == null) {
            return -1;
        }
        return team.getMember(player).role().getPermissionLevel();
    }

    public static boolean arePlayersSameTeam(Player player1, Player player2) {
        UUID uuid1 = player1.getUUID();
        UUID uuid2 = player2.getUUID();
        return ResearchTeamHelper.arePlayersSameTeam(player1.level(), uuid1, uuid2);
    }

    public static boolean arePlayersSameTeam(Player player1, UUID uuid2) {
        UUID uuid1 = player1.getUUID();
        return ResearchTeamHelper.arePlayersSameTeam(player1.level(), uuid1, uuid2);
    }

    public static boolean arePlayersSameTeam(Level level, UUID uuid1, UUID uuid2) {
        ResearchTeamMap savedData = (ResearchTeamMap)ResearchdSavedData.TEAM_RESEARCH.get().getData(level);
        ResearchTeam team1 = savedData.getTeamByMemberOrThrow(uuid1);
        ResearchTeam team2 = savedData.getTeamByMemberOrThrow(uuid2);
        return team1.getId().equals(team2.getId());
    }

    public static void handleEnterTeam(ServerPlayer requester, UUID memberOfTeam) {
        Level level = requester.level();
        UUID requesterId = requester.getUUID();
        ResearchTeamMap savedData = (ResearchTeamMap)ResearchdSavedData.TEAM_RESEARCH.get().getData(level);
        SimpleResearchTeam team = savedData.getTeamByMember(memberOfTeam);
        if (ResearchTeamHelper.getTeamByMember((Player)requester).getMembersAmount() > 1) {
            requester.sendSystemMessage((Component)ResearchdTranslations.component(ResearchdTranslations.Team.ALREADY_IN_TEAM, new Object[0]));
            return;
        }
        if (team != null && team.getSocialManager().containsSentInvite(requesterId)) {
            ResearchTeamHelper.handleLeaveTeam(requester);
            savedData.researchTeams().put(requesterId, team);
            requester.sendSystemMessage((Component)ResearchdTranslations.component(ResearchdTranslations.Team.YOU_JOINED_TEAM, team.getName()));
            for (TeamMember member : team.getMembers()) {
                Player memberPlayer = level.getPlayerByUUID(member.player());
                if (memberPlayer == null) continue;
                memberPlayer.sendSystemMessage((Component)ResearchdTranslations.component(ResearchdTranslations.Team.PLAYER_JOINED_TEAM, PlayerUtils.getPlayerNameFromUUID((Level)level, (UUID)requesterId)));
            }
            team.addMember(requesterId);
            team.getSocialManager().removeSentInvite(requesterId);
            ResearchdSavedData.TEAM_RESEARCH.get().setData(level, (Object)savedData);
            ResearchdSavedData.TEAM_RESEARCH.get().sync(level);
            ResearchTeamHelper.refreshPlayerManagement(team, level);
            PacketDistributor.sendToPlayer((ServerPlayer)requester, (CustomPacketPayload)new RefreshResearchesPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void handleIgnoreTeam(ServerPlayer requester, UUID memberOfTeam) {
        Level level = requester.level();
        ResearchTeamMap savedData = (ResearchTeamMap)ResearchdSavedData.TEAM_RESEARCH.get().getData(level);
        SimpleResearchTeam team = savedData.getTeamByMember(memberOfTeam);
        if (team != null) {
            team.getSocialManager().addIgnore(requester.getUUID());
            requester.sendSystemMessage((Component)ResearchdTranslations.component(ResearchdTranslations.Team.IGNORE, team.getName()));
        }
    }

    public static void handleLeaveTeam(ServerPlayer requester, @Nullable UUID nextToLead) {
        MinecraftServer server = requester.getServer();
        ServerLevel level = server.overworld();
        UUID requesterId = requester.getUUID();
        ResearchTeamMap savedData = (ResearchTeamMap)ResearchdSavedData.TEAM_RESEARCH.get().getData((Level)level);
        ResearchTeam team = ResearchTeamHelper.getTeamByMember((Player)requester);
        if (team.isOwner(requesterId)) {
            if (team.getMembersAmount() <= 1) {
                savedData.researchTeams().remove(requesterId);
                requester.sendSystemMessage((Component)ResearchdTranslations.component(ResearchdTranslations.Team.LEFT_TEAM, new Object[0]));
                savedData.researchTeams().put(requesterId, SimpleResearchTeam.createDefaultTeam(requester));
            } else {
                if (nextToLead == null || nextToLead.equals(PlayerUtils.EmptyUUID)) {
                    requester.sendSystemMessage((Component)ResearchdTranslations.component(ResearchdTranslations.Team.NO_NEXT_LEADER, new Object[0]));
                    return;
                }
                ResearchTeamHelper.handleTransferOwnership(requester, nextToLead);
            }
            ResearchdSavedData.TEAM_RESEARCH.get().setData((Level)level, (Object)savedData);
            ResearchdSavedData.TEAM_RESEARCH.get().sync((Level)level);
            PacketDistributor.sendToPlayer((ServerPlayer)requester, (CustomPacketPayload)new RefreshResearchesPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            ResearchTeamHelper.removeMember(requester);
            requester.sendSystemMessage((Component)ResearchdTranslations.component(ResearchdTranslations.Team.LEFT_TEAM, new Object[0]));
            savedData.researchTeams().put(requesterId, SimpleResearchTeam.createDefaultTeam(requester));
            PacketDistributor.sendToPlayer((ServerPlayer)requester, (CustomPacketPayload)ClearGraphCachePayload.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
            ResearchdSavedData.TEAM_RESEARCH.get().sync((Level)level);
            ResearchTeamHelper.refreshPlayerManagement(team, (Level)level);
        }
    }

    public static void handleLeaveTeam(ServerPlayer requester) {
        ResearchTeamHelper.handleLeaveTeam(requester, PlayerUtils.EmptyUUID);
    }

    public static void handleManageMember(ServerPlayer requester, UUID member, boolean remove) {
        MinecraftServer server = requester.getServer();
        ServerLevel level = server.overworld();
        ResearchTeamMap savedData = (ResearchTeamMap)ResearchdSavedData.TEAM_RESEARCH.get().getData((Level)level);
        if (requester.getUUID().equals(member)) {
            requester.sendSystemMessage((Component)ResearchTeamHelper.getIllegalMessage());
            return;
        }
        if (!ResearchTeamHelper.arePlayersSameTeam((Player)requester, member)) {
            return;
        }
        if (ResearchTeamHelper.getPermissionLevel((Player)requester) >= 1 && ResearchTeamHelper.getPermissionLevel((Player)requester) > ResearchTeamHelper.getPermissionLevel(member, requester.level())) {
            if (remove) {
                ResearchTeamHelper.getTeamByMember((Player)requester).removeMember(member);
                requester.sendSystemMessage((Component)ResearchdTranslations.component(ResearchdTranslations.Team.REMOVED, PlayerUtils.getPlayerNameFromUUID((Level)level, (UUID)member)));
                ServerPlayer kickedPlayer = server.getPlayerList().getPlayer(member);
                if (kickedPlayer != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)kickedPlayer, (CustomPacketPayload)ClearGraphCachePayload.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
                    kickedPlayer.sendSystemMessage((Component)ResearchdTranslations.component(ResearchdTranslations.Team.KICKED, ResearchTeamHelper.getTeamByMember((Player)requester).getName()));
                }
                savedData.setDefaultTeam(member, requester.level());
            } else {
                ResearchTeamHelper.getTeamByMember((Player)requester).getSocialManager().addSentInvite(member);
            }
            ResearchdSavedData.TEAM_RESEARCH.get().setData((Level)level, (Object)savedData);
            ResearchdSavedData.TEAM_RESEARCH.get().sync((Level)level);
            ResearchTeamHelper.refreshPlayerManagement(ResearchTeamHelper.getTeamByMember((Player)requester), (Level)level);
        } else {
            requester.sendSystemMessage((Component)ResearchdTranslations.component(ResearchdTranslations.Team.NO_PERMS, new Object[0]));
        }
        ResearchdSavedData.TEAM_RESEARCH.get().sync((Level)level);
    }

    public static void handleManageModerator(ServerPlayer requester, UUID moderator, boolean remove) {
        MinecraftServer server = requester.getServer();
        ServerLevel level = server.overworld();
        ResearchTeamMap savedData = (ResearchTeamMap)ResearchdSavedData.TEAM_RESEARCH.get().getData((Level)level);
        if (requester.getUUID().equals(moderator)) {
            requester.sendSystemMessage((Component)ResearchTeamHelper.getIllegalMessage());
            return;
        }
        if (ResearchTeamHelper.getPermissionLevel((Player)requester) == 2) {
            if (ResearchTeamHelper.arePlayersSameTeam((Player)requester, moderator)) {
                ResearchTeam team = ResearchTeamHelper.getTeamByMember((Player)requester);
                if (remove) {
                    team.setRole(moderator, ResearchTeamRole.MEMBER);
                    requester.sendSystemMessage((Component)ResearchdTranslations.component(ResearchdTranslations.Team.DEMOTED, PlayerUtils.getPlayerNameFromUUID((Level)level, (UUID)moderator)));
                } else {
                    team.setRole(moderator, ResearchTeamRole.MODERATOR);
                    requester.sendSystemMessage((Component)ResearchdTranslations.component(ResearchdTranslations.Team.PROMOTED, PlayerUtils.getPlayerNameFromUUID((Level)level, (UUID)moderator)));
                }
                ResearchdSavedData.TEAM_RESEARCH.get().setData((Level)level, (Object)savedData);
                ResearchdSavedData.TEAM_RESEARCH.get().sync((Level)level);
                ResearchTeamHelper.refreshPlayerManagement(ResearchTeamHelper.getTeamByMember((Player)requester), (Level)level);
            } else {
                requester.sendSystemMessage((Component)ResearchdTranslations.component(ResearchdTranslations.Team.BAD_INPUT, new Object[0]));
            }
        } else {
            requester.sendSystemMessage((Component)ResearchdTranslations.component(ResearchdTranslations.Team.NO_PERMS, new Object[0]));
        }
    }

    public static void handleSetName(ServerPlayer requester, String name) {
        UUID requesterId = requester.getUUID();
        MinecraftServer server = requester.getServer();
        ServerLevel level = server.overworld();
        ResearchTeamMap savedData = (ResearchTeamMap)ResearchdSavedData.TEAM_RESEARCH.get().getData((Level)level);
        if (ResearchTeamHelper.getPermissionLevel((Player)requester) == 2) {
            if (name.isEmpty()) {
                requester.sendSystemMessage((Component)ResearchdTranslations.component(ResearchdTranslations.Team.NAME_CANNOT_BE_EMPTY, new Object[0]));
                return;
            }
            String oldname = ResearchTeamHelper.getTeamByMember((Player)requester).getName();
            ResearchTeamHelper.getTeamByMember((Player)requester).setName(name);
            requester.sendSystemMessage((Component)ResearchdTranslations.component(ResearchdTranslations.Team.NEW_TEAM_NAME, oldname, name));
            ResearchdSavedData.TEAM_RESEARCH.get().setData((Level)level, (Object)savedData);
            ResearchdSavedData.TEAM_RESEARCH.get().sync((Level)level);
            ResearchTeamHelper.refreshPlayerManagement(ResearchTeamHelper.getTeamByMember((Player)requester), (Level)level);
        } else {
            requester.sendSystemMessage((Component)ResearchdTranslations.component(ResearchdTranslations.Team.NO_PERMS, new Object[0]));
        }
    }

    public static void handleTransferOwnership(ServerPlayer requester, UUID nextToLead) {
        MinecraftServer server = requester.getServer();
        ServerLevel level = server.overworld();
        UUID requesterId = requester.getUUID();
        ResearchTeamMap savedData = (ResearchTeamMap)ResearchdSavedData.TEAM_RESEARCH.get().getData(requester.level());
        if (ResearchTeamHelper.getPermissionLevel((Player)requester) == 2) {
            if (ResearchTeamHelper.arePlayersSameTeam((Level)level, requesterId, nextToLead)) {
                ResearchTeam team = ResearchTeamHelper.getTeamByMember((Player)requester);
                team.setRole(nextToLead, ResearchTeamRole.OWNER);
                team.setRole(requesterId, ResearchTeamRole.MODERATOR);
                ResearchdSavedData.TEAM_RESEARCH.get().setData((Level)level, (Object)savedData);
                ResearchdSavedData.TEAM_RESEARCH.get().sync((Level)level);
                requester.sendSystemMessage((Component)ResearchdTranslations.component(ResearchdTranslations.Team.TRANSFERRED_OWNERSHIP, PlayerUtils.getPlayerNameFromUUID((Level)level, (UUID)nextToLead)));
                ResearchTeamHelper.refreshPlayerManagement(team, (Level)level);
            } else {
                requester.sendSystemMessage((Component)ResearchdTranslations.component(ResearchdTranslations.Team.BAD_INPUT, new Object[0]));
            }
        }
    }

    public static void handleListMembers(ServerPlayer requester) {
        ResearchTeam team = ResearchTeamHelper.getTeamByMember((Player)requester);
        requester.sendSystemMessage(ResearchTeamHelper.formatMembers(team, requester.level()));
    }

    public static Component formatMembers(ResearchTeam team, Level level) {
        MutableComponent formattedTeam = Component.literal((String)team.getName()).withStyle(ChatFormatting.AQUA);
        formattedTeam.append((Component)Component.literal((String)" has %d member%s: ".formatted(team.getMembersAmount(), team.getMembersAmount() == 1 ? "" : "s")).withStyle(ChatFormatting.WHITE));
        for (TeamMember member : team.getMembers()) {
            Player player = level.getPlayerByUUID(member.player());
            if (player == null) continue;
            formattedTeam.append((Component)Component.literal((String)(player.getName().getString() + " ")).withStyle(ChatFormatting.AQUA));
        }
        return formattedTeam;
    }

    public static void handleSendInviteToPlayer(ServerPlayer requester, UUID invited, boolean remove) {
        ResearchTeam team = ResearchTeamHelper.getTeamByMember((Player)requester);
        if (requester.getUUID().equals(invited)) {
            requester.sendSystemMessage((Component)ResearchTeamHelper.getIllegalMessage());
            return;
        }
        if (remove) {
            team.getSocialManager().removeSentInvite(invited);
            requester.sendSystemMessage((Component)ResearchdTranslations.component(ResearchdTranslations.Team.REMOVED_INVITE, AllPlayersCache.getName((UUID)invited)));
        } else {
            team.getSocialManager().addSentInvite(invited);
            ServerPlayer invitedPlayer = (ServerPlayer)requester.serverLevel().getPlayerByUUID(invited);
            if (invitedPlayer != null) {
                invitedPlayer.sendSystemMessage((Component)ResearchdTranslations.component(ResearchdTranslations.Team.RECEIVED_INVITE, team.getName()).append((Component)Component.literal((String)"\n")).append("     ").append((Component)ResearchdTranslations.component(ResearchdTranslations.Team.ACCEPT, new Object[0]).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/researchd team join " + AllPlayersCache.getName((UUID)requester.getUUID()))))).append("     ").append((Component)ResearchdTranslations.component(ResearchdTranslations.Team.DECLINE, new Object[0]).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/researchd team ignore " + AllPlayersCache.getName((UUID)requester.getUUID()))))));
            }
            requester.sendSystemMessage((Component)ResearchdTranslations.component(ResearchdTranslations.Team.SENT_INVITE, AllPlayersCache.getName((UUID)invited), team.getName()));
        }
        Level level = requester.level();
        ResearchdSavedData.TEAM_RESEARCH.get().setData(level, (Object)((ResearchTeamMap)ResearchdSavedData.TEAM_RESEARCH.get().getData(level)));
        ResearchdSavedData.TEAM_RESEARCH.get().sync(level);
        ResearchTeamHelper.refreshPlayerManagement(team, level);
    }

    public static Collection<? extends ResearchTeam> getTeams(Level level) {
        return ((ResearchTeamMap)ResearchdSavedData.TEAM_RESEARCH.get().getData(level)).researchTeams().values();
    }

    public static Component getFormattedDump(Level level) {
        ArrayList<MutableComponent> dump = new ArrayList<MutableComponent>();
        HashSet<SimpleResearchTeam> uniqueTeams = new HashSet<SimpleResearchTeam>(((ResearchTeamMap)ResearchdSavedData.TEAM_RESEARCH.get().getData(level)).researchTeams().values());
        dump.add(Component.literal((String)"---- Researchd Teams ----").withStyle(ChatFormatting.GOLD));
        Iterator iterator = uniqueTeams.iterator();
        while (iterator.hasNext()) {
            ResearchTeam team = (ResearchTeam)iterator.next();
            dump.add(Component.literal((String)(String.valueOf(ChatFormatting.GREEN) + team.getName() + String.valueOf(ChatFormatting.RESET))).append(" with %s member%s".formatted(ChatFormatting.GREEN.toString() + team.getMembersAmount() + String.valueOf(ChatFormatting.RESET), team.getMembersAmount() == 1 ? "" : "s")));
            for (TeamMember member : team.getMembers()) {
                dump.add(Component.literal((String)"\u2523 ").append(member.getName()).withStyle(ChatFormatting.GRAY));
            }
            if (iterator.hasNext()) {
                dump.add(Component.literal((String)"\u2523\u2501\u2501").withStyle(ChatFormatting.GRAY));
                continue;
            }
            dump.add(Component.literal((String)"\u2517\u2501\u2501").withStyle(ChatFormatting.GRAY));
        }
        MutableComponent ret = Component.empty();
        for (int i = 0; i < dump.size(); ++i) {
            Component component = (Component)dump.get(i);
            ret.append(component);
            if (i >= dump.size() - 1) continue;
            ret.append("\n");
        }
        return ret;
    }

    public static MutableComponent paramDescription(String param, String description) {
        MutableComponent paramComp = Component.literal((String)("<" + param + ">")).withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.ITALIC});
        return paramComp.append((Component)Component.literal((String)(" - " + description)).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
    }

    public static MutableComponent description(String description) {
        return Component.literal((String)(" - " + description)).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
    }

    public static MutableComponent helpMessage(String categ, String command, Component ... description) {
        MutableComponent ret = Component.literal((String)("/researchd " + categ + " ")).withStyle(ChatFormatting.AQUA);
        ret.append((Component)Component.literal((String)command).withStyle(ChatFormatting.WHITE));
        for (Component desc : description) {
            ret.append("\n");
            ret.append(desc);
        }
        return ret;
    }

    public static void cleanupTeamResearches(ResearchTeamMap teamMap, Level level) {
        for (SimpleResearchTeam team : teamMap.researchTeams().values()) {
            Map<ResourceKey<Research>, ResearchInstance> researches = team.getResearches();
            HashMap<ResourceKey<Research>, ResearchInstance> newResearches = new HashMap<ResourceKey<Research>, ResearchInstance>();
            for (Map.Entry<ResourceKey<Research>, ResearchInstance> entry : researches.entrySet()) {
                if (ResearchHelperCommon.getResearch(entry.getKey(), level) == null || entry.getValue().getKey() == null) continue;
                newResearches.put(entry.getKey(), entry.getValue());
            }
            researches.clear();
            researches.putAll(newResearches);
        }
    }

    public static void sendHelpMessage(Consumer<Component> sendMessageFunction) {
        sendMessageFunction.accept((Component)Component.literal((String)"> Researchd Teams").withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD}));
        sendMessageFunction.accept((Component)ResearchTeamHelper.helpMessage("team", "create <name>", new Component[]{ResearchTeamHelper.description("Create a new team with the specified name.")}));
        sendMessageFunction.accept((Component)ResearchTeamHelper.helpMessage("team", "list", new Component[]{ResearchTeamHelper.description("List all teams.")}));
        sendMessageFunction.accept((Component)ResearchTeamHelper.helpMessage("team", "members", new Component[]{ResearchTeamHelper.description("List all members of your team.")}));
        sendMessageFunction.accept((Component)ResearchTeamHelper.helpMessage("team", "invite <player>", new Component[]{ResearchTeamHelper.description("Invite a player to your team.")}));
        sendMessageFunction.accept((Component)ResearchTeamHelper.helpMessage("team", "join <player>", new Component[]{ResearchTeamHelper.description("Join a team that you have been invited to.")}));
        sendMessageFunction.accept((Component)ResearchTeamHelper.helpMessage("team", "leave <next_to_lead>", new Component[]{ResearchTeamHelper.paramDescription("next_to_lead", "Put 'none' if there's no-one to lead or you're not the leader."), ResearchTeamHelper.description("Leave your current team.")}));
        sendMessageFunction.accept((Component)ResearchTeamHelper.helpMessage("team", "promote <player>", new Component[]{ResearchTeamHelper.description("Promote a player to moderator. You got to be the leader to do this.")}));
        sendMessageFunction.accept((Component)ResearchTeamHelper.helpMessage("team", "demote <player>", new Component[]{ResearchTeamHelper.description("Demote a player from moderator. You got to be the leader to do this.")}));
        sendMessageFunction.accept((Component)ResearchTeamHelper.helpMessage("team", "kick <player>", new Component[]{ResearchTeamHelper.description("Kick a player from your team. You got to be a moderator or the leader to do this.")}));
        sendMessageFunction.accept((Component)ResearchTeamHelper.helpMessage("team", "transfer-ownership <player>", new Component[]{ResearchTeamHelper.description("Transfer ownership of the team to another player.")}));
        sendMessageFunction.accept((Component)ResearchTeamHelper.helpMessage("team", "set-name <name>", new Component[]{ResearchTeamHelper.description("Set a new name for your team.")}));
    }

    public static MutableComponent illegalMessage(String message) {
        return Component.literal((String)message).withStyle(ChatFormatting.RED);
    }

    public static MutableComponent getIllegalMessage() {
        ArrayList<MutableComponent> msgs = new ArrayList<MutableComponent>();
        msgs.add(ResearchTeamHelper.illegalMessage("No."));
        msgs.add(ResearchTeamHelper.illegalMessage("Nope."));
        msgs.add(ResearchTeamHelper.illegalMessage("Not happening."));
        msgs.add(ResearchTeamHelper.illegalMessage("Nuh uh."));
        msgs.add(ResearchTeamHelper.illegalMessage("No chance."));
        msgs.add(ResearchTeamHelper.illegalMessage("Stop."));
        msgs.add(ResearchTeamHelper.illegalMessage("You gonna keep doin that?"));
        msgs.add(ResearchTeamHelper.illegalMessage("You're just spamming the console at this point."));
        msgs.add(ResearchTeamHelper.illegalMessage("You're not getting anywhere with this."));
        return (MutableComponent)msgs.get((int)Math.floor(Math.random() * (double)msgs.size()));
    }

    public static void initializeTeamResearches(ResearchTeamMap teamMap, Level level) {
        for (SimpleResearchTeam team : teamMap.researchTeams().values()) {
            Map<ResourceKey<Research>, ResearchInstance> researches = team.getResearches();
            Map<ResourceKey<Research>, ResearchProgress> progress = team.getResearchProgresses();
            HashSet<GlobalResearch> globalResearches = new HashSet<GlobalResearch>(CommonResearchCache.globalResearches.values());
            for (GlobalResearch research : globalResearches) {
                if (progress.containsKey(research.getResearchKey())) continue;
                progress.put(research.getResearchKey(), ResearchProgress.forResearch(research.getResearchKey(), level));
            }
            researches.values().stream().map(ResearchInstance::getResearch).forEach(globalResearches::remove);
            for (GlobalResearch globalResearch : globalResearches) {
                ResearchStatus status = CommonResearchCache.rootResearch != null && CommonResearchCache.rootResearch.is(globalResearch.getResearchKey()) ? ResearchStatus.RESEARCHABLE : ResearchStatus.LOCKED;
                researches.put(globalResearch.getResearchKey(), new ResearchInstance(globalResearch, status));
            }
        }
    }

    public static void resolveGlobalResearches(ResearchTeamMap researchTeamMap) {
        for (ResearchTeam researchTeam : researchTeamMap.researchTeams().values()) {
            for (Map.Entry<ResourceKey<Research>, ResearchInstance> entry : researchTeam.getResearches().entrySet()) {
                entry.setValue(new ResearchInstance(CommonResearchCache.globalResearches.get(entry.getKey()), entry.getValue().getResearchStatus(), entry.getValue().getResearchedPlayer(), entry.getValue().getResearchedTime()));
            }
        }
    }

    public static void refreshPlayerManagement(ResearchTeam team, Level level) {
        if (team == null) {
            return;
        }
        for (TeamMember member : team.getMembers()) {
            ServerPlayer player = level.getServer().getPlayerList().getPlayer(member.player());
            if (player == null) continue;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)RefreshPlayerManagementPayload.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static enum HelpPage {
        TEAM;

    }
}

