/*
 * Decompiled with CFR 0.152.
 */
package infinituum.void_lib.fabric.scanner;

import infinituum.void_lib.VoidLib;
import infinituum.void_lib.fabric.scanner.ModAnnotationFileTreeVisitor;
import infinituum.void_lib.fabric.scanner.api.AnnotatedClass;
import infinituum.void_lib.fabric.scanner.api.ScannedFile;
import infinituum.void_lib.fabric.scanner.impl.ScannedModFile;
import infinituum.void_lib.fabric.utils.DevModContainer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public final class ModAnnotationScanner {
    private static volatile ModAnnotationScanner INSTANCE;
    private final Set<String> excludedMods;
    private final Set<String> excludedAuthors;
    private final Set<ScannedFile> result;

    private ModAnnotationScanner() {
        Collection loadedMods = FabricLoader.getInstance().getAllMods();
        this.excludedMods = Set.of("java", "minecraft", "fabricloader", "mixinextras", "void_lib");
        this.excludedAuthors = Set.of("FabricMC");
        VoidLib.LOGGER.info("Scanning jar files for annotations...");
        long startTime = System.currentTimeMillis();
        this.result = this.scan(loadedMods);
        long endTime = System.currentTimeMillis();
        VoidLib.LOGGER.info("Scan completed in {} ms!", (Object)(endTime - startTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ModAnnotationScanner init() {
        if (INSTANCE != null) return INSTANCE;
        Class<ModAnnotationScanner> clazz = ModAnnotationScanner.class;
        synchronized (ModAnnotationScanner.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ModAnnotationScanner();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public Set<ScannedFile> get() {
        return this.result;
    }

    public Set<ScannedFile> search(Class<?> annotationClass) {
        return this.get().stream().filter(modFile -> modFile.getAnnotatedClasses().stream().anyMatch(clazz -> clazz != null && clazz.contains(annotationClass))).collect(Collectors.toSet());
    }

    public Set<ScannedFile> search(Class<?> annotationClass, String dependencyId) {
        return this.get().stream().filter(modFile -> modFile.getDependencies().stream().anyMatch(dependency -> dependencyId.equals(dependency.getModId())) || dependencyId.equals(modFile.getModId()) || FabricLoader.getInstance().isDevelopmentEnvironment() && (modFile.getModId().isEmpty() || modFile.getModId().startsWith("generated_"))).filter(modFile -> modFile.getAnnotatedClasses().stream().anyMatch(clazz -> clazz.contains(annotationClass))).collect(Collectors.toSet());
    }

    private Set<ScannedFile> scan(Collection<ModContainer> mods) {
        HashSet<ScannedFile> result;
        block10: {
            result = new HashSet<ScannedFile>();
            for (ModContainer mod : mods) {
                Set<AnnotatedClass> classes;
                String modId = mod.getMetadata().getId();
                Collection authors = mod.getMetadata().getAuthors();
                boolean isExcludedMod = this.excludedMods.contains(modId);
                boolean isExcludedAuthor = authors.stream().anyMatch(person -> this.excludedAuthors.contains(person.getName()));
                if (!(isExcludedMod || isExcludedAuthor || (classes = this.scanEntrypoints(mod.getRootPaths())).isEmpty())) {
                    VoidLib.LOGGER.info("Found {} annotated classes in mod '{}'", (Object)classes.size(), (Object)modId);
                    result.add(new ScannedModFile(mod, classes));
                }
                if (mod.getContainedMods().isEmpty()) continue;
                this.scan(mod.getContainedMods());
            }
            try {
                if (!FabricLoader.getInstance().isDevelopmentEnvironment()) break block10;
                try {
                    Path baseDir = FabricLoader.getInstance().getGameDir();
                    if (!baseDir.isAbsolute()) {
                        baseDir = baseDir.toAbsolutePath().getParent();
                    }
                    Path developmentEntrypoint = baseDir.getParent().resolve("build").resolve("classes").resolve("java").resolve("main");
                    try {
                        List<Path> rootPaths = List.of(developmentEntrypoint);
                        Set<AnnotatedClass> classes = this.scanEntrypoints(rootPaths);
                        if (!classes.isEmpty()) {
                            VoidLib.LOGGER.info("Found current DEV mod with {} annotated classes", (Object)classes.size());
                            result.add(new ScannedModFile(new DevModContainer(rootPaths), classes));
                        }
                    }
                    catch (Exception e) {
                        VoidLib.LOGGER.warn("Could not read 'build/classes/java/main' directory in development environment. Searched path: {}", (Object)developmentEntrypoint);
                    }
                }
                catch (Exception e) {
                    VoidLib.LOGGER.warn("Could not determine development entrypoint (should be 'build/main/java')");
                }
            }
            catch (Exception e) {
                VoidLib.LOGGER.warn("Could not read developed mod's classes. Ignore this message if you're running tests");
            }
        }
        return result;
    }

    private Set<AnnotatedClass> scanEntrypoints(List<Path> entrypoints) {
        HashSet<AnnotatedClass> annotatedClasses = new HashSet<AnnotatedClass>();
        for (Path entrypoint : entrypoints) {
            annotatedClasses.addAll(this.scanEntrypoint(entrypoint));
        }
        return Collections.unmodifiableSet(annotatedClasses);
    }

    public Set<AnnotatedClass> scanEntrypoint(Path entrypoint) {
        ModAnnotationFileTreeVisitor visitor = new ModAnnotationFileTreeVisitor(entrypoint);
        return this.scanAnnotations(visitor);
    }

    private Set<AnnotatedClass> scanAnnotations(ModAnnotationFileTreeVisitor visitor) {
        try {
            Files.walkFileTree(visitor.getBasePath(), visitor);
        }
        catch (IOException e) {
            VoidLib.LOGGER.error("Could not visit classes of entrypoint '{}'", (Object)visitor.getBasePath());
        }
        return visitor.getAnnotatedClasses();
    }
}

