/*
 * Decompiled with CFR 0.152.
 */
package infinituum.void_lib.fabric.scanner.asm;

import infinituum.void_lib.fabric.scanner.asm.ModAnnotationVisitor;
import infinituum.void_lib.fabric.scanner.impl.AnnotatedClassImpl;
import infinituum.void_lib.fabric.scanner.impl.AnnotatedMethodImpl;
import infinituum.void_lib.fabric.scanner.impl.MethodInstructionAnnotation;
import infinituum.void_lib.fabric.scanner.impl.MethodLocalVariableAnnotation;
import infinituum.void_lib.fabric.scanner.impl.MethodParameterAnnotation;
import infinituum.void_lib.fabric.scanner.impl.MethodTryCatchAnnotation;
import infinituum.void_lib.fabric.scanner.impl.MethodTypeAnnotation;
import infinituum.void_lib.fabric.scanner.impl.ModAnnotation;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;

public final class ModAnnotationMethodVisitor
extends MethodVisitor {
    private final AnnotatedClassImpl clazz;
    private final AnnotatedMethodImpl method;

    public ModAnnotationMethodVisitor(MethodVisitor methodVisitor, AnnotatedClassImpl clazz, String descriptor, String name) {
        super(589824, methodVisitor);
        this.clazz = clazz;
        this.method = new AnnotatedMethodImpl(clazz.getName(), descriptor, name);
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        AnnotationVisitor nextVisitor = super.visitAnnotation(descriptor, visible);
        Type annotationType = Type.getType((String)descriptor);
        String annotationName = annotationType.getClassName();
        ModAnnotation annotation = new ModAnnotation(annotationName);
        this.method.addAnnotation(annotation);
        return new ModAnnotationVisitor(nextVisitor, annotation);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        AnnotationVisitor nextVisitor = super.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
        Type annotationType = Type.getType((String)descriptor);
        String annotationName = annotationType.getClassName();
        MethodTypeAnnotation annotation = new MethodTypeAnnotation(annotationName, typeRef, typePath);
        this.method.addTypeAnnotation(annotation);
        return new ModAnnotationVisitor(nextVisitor, annotation);
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
        AnnotationVisitor nextVisitor = super.visitParameterAnnotation(parameter, descriptor, visible);
        Type annotationType = Type.getType((String)descriptor);
        String annotationName = annotationType.getClassName();
        MethodParameterAnnotation annotation = new MethodParameterAnnotation(annotationName, parameter);
        this.method.addParameterAnnotation(annotation);
        return new ModAnnotationVisitor(nextVisitor, annotation);
    }

    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        AnnotationVisitor nextVisitor = super.visitInsnAnnotation(typeRef, typePath, descriptor, visible);
        Type annotationType = Type.getType((String)descriptor);
        String annotationName = annotationType.getClassName();
        MethodInstructionAnnotation annotation = new MethodInstructionAnnotation(annotationName, typeRef, typePath);
        this.method.addInstructionAnnotation(annotation);
        return new ModAnnotationVisitor(nextVisitor, annotation);
    }

    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        AnnotationVisitor nextVisitor = super.visitTryCatchAnnotation(typeRef, typePath, descriptor, visible);
        Type annotationType = Type.getType((String)descriptor);
        String annotationName = annotationType.getClassName();
        MethodTryCatchAnnotation annotation = new MethodTryCatchAnnotation(annotationName, typeRef, typePath);
        this.method.addTryCatchAnnotation(annotation);
        return new ModAnnotationVisitor(nextVisitor, annotation);
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String descriptor, boolean visible) {
        AnnotationVisitor nextVisitor = super.visitLocalVariableAnnotation(typeRef, typePath, start, end, index, descriptor, visible);
        Type annotationType = Type.getType((String)descriptor);
        String annotationName = annotationType.getClassName();
        MethodLocalVariableAnnotation annotation = new MethodLocalVariableAnnotation(annotationName, typeRef, typePath, start, end, index);
        this.method.addLocalVariableAnnotation(annotation);
        return new ModAnnotationVisitor(nextVisitor, annotation);
    }

    public void visitEnd() {
        if (this.hasAnyAnnotations()) {
            this.clazz.add(this.method);
        }
        super.visitEnd();
    }

    private boolean hasAnyAnnotations() {
        return !this.method.getAnnotations().isEmpty() || !this.method.getTypeAnnotations().isEmpty() || !this.method.getParameterAnnotations().isEmpty() || !this.method.getInstructionAnnotations().isEmpty() || !this.method.getTryCatchAnnotations().isEmpty() || !this.method.getLocalVariableAnnotations().isEmpty();
    }
}

