/*
 * Decompiled with CFR 0.152.
 */
package infinituum.void_lib.fabric.scanner.impl;

import infinituum.void_lib.fabric.scanner.api.AnnotatedField;
import infinituum.void_lib.fabric.scanner.api.Annotation;
import java.util.ArrayList;
import java.util.List;

public final class AnnotatedFieldImpl
implements AnnotatedField {
    private final String descriptor;
    private final String className;
    private final String fieldName;
    private final List<Annotation> fieldAnnotations;

    public AnnotatedFieldImpl(String className, String descriptor, String fieldName) {
        this.className = className;
        this.descriptor = descriptor;
        this.fieldName = fieldName;
        this.fieldAnnotations = new ArrayList<Annotation>();
    }

    public void add(Annotation annotation) {
        this.fieldAnnotations.add(annotation);
    }

    @Override
    public String getDescriptor() {
        return this.descriptor;
    }

    @Override
    public boolean hasAnnotations() {
        return !this.fieldAnnotations.isEmpty();
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getName() {
        return this.fieldName;
    }

    @Override
    public boolean contains(Class<?> annotationClass) {
        if (!this.hasAnnotations()) {
            return false;
        }
        return this.fieldAnnotations.stream().anyMatch(annotation -> annotation.is(annotationClass));
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.fieldAnnotations;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Name: ").append(this.fieldName).append("\n");
        result.append("Descriptor: ").append(this.descriptor).append("\n");
        result.append("Class Name: ").append(this.className).append("\n");
        if (this.hasAnnotations()) {
            result.append("Annotations: \n");
            for (Annotation annotation : this.fieldAnnotations) {
                result.append(" - ").append(annotation.toString().replace("\n", "\n   ")).append("\n");
            }
        }
        return result.toString();
    }
}

