/*
 * Decompiled with CFR 0.152.
 */
package infinituum.void_lib.fabric.scanner.impl;

import infinituum.void_lib.fabric.scanner.api.AnnotatedMethod;
import infinituum.void_lib.fabric.scanner.api.Annotation;
import infinituum.void_lib.fabric.scanner.api.InstructionAnnotation;
import infinituum.void_lib.fabric.scanner.api.LocalVariableAnnotation;
import infinituum.void_lib.fabric.scanner.api.ParameterAnnotation;
import infinituum.void_lib.fabric.scanner.api.TryCatchAnnotation;
import infinituum.void_lib.fabric.scanner.api.TypeAnnotation;
import infinituum.void_lib.fabric.scanner.impl.MethodInstructionAnnotation;
import infinituum.void_lib.fabric.scanner.impl.MethodLocalVariableAnnotation;
import infinituum.void_lib.fabric.scanner.impl.MethodParameterAnnotation;
import infinituum.void_lib.fabric.scanner.impl.MethodTryCatchAnnotation;
import infinituum.void_lib.fabric.scanner.impl.MethodTypeAnnotation;
import infinituum.void_lib.fabric.scanner.impl.ModAnnotation;
import java.util.ArrayList;
import java.util.List;

public final class AnnotatedMethodImpl
implements AnnotatedMethod {
    private final String descriptor;
    private final String className;
    private final String methodName;
    private final List<Annotation> methodAnnotations;
    private final List<TypeAnnotation> typeAnnotations;
    private final List<ParameterAnnotation> parameterAnnotations;
    private final List<InstructionAnnotation> instructionAnnotations;
    private final List<TryCatchAnnotation> tryCatchAnnotations;
    private final List<LocalVariableAnnotation> localVariableAnnotations;

    public AnnotatedMethodImpl(String className, String descriptor, String methodName) {
        this.className = className;
        this.descriptor = descriptor;
        this.methodName = methodName;
        this.methodAnnotations = new ArrayList<Annotation>();
        this.typeAnnotations = new ArrayList<TypeAnnotation>();
        this.parameterAnnotations = new ArrayList<ParameterAnnotation>();
        this.instructionAnnotations = new ArrayList<InstructionAnnotation>();
        this.tryCatchAnnotations = new ArrayList<TryCatchAnnotation>();
        this.localVariableAnnotations = new ArrayList<LocalVariableAnnotation>();
    }

    @Override
    public String getDescriptor() {
        return this.descriptor;
    }

    @Override
    public boolean hasAnnotations() {
        return !this.methodAnnotations.isEmpty();
    }

    @Override
    public boolean hasTypeAnnotations() {
        return !this.typeAnnotations.isEmpty();
    }

    @Override
    public boolean hasParameterAnnotations() {
        return !this.parameterAnnotations.isEmpty();
    }

    @Override
    public boolean hasInstructionAnnotations() {
        return !this.instructionAnnotations.isEmpty();
    }

    @Override
    public boolean hasTryCatchAnnotations() {
        return !this.tryCatchAnnotations.isEmpty();
    }

    @Override
    public boolean hasLocalVariableAnnotations() {
        return !this.localVariableAnnotations.isEmpty();
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.methodAnnotations;
    }

    @Override
    public List<TypeAnnotation> getTypeAnnotations() {
        return this.typeAnnotations;
    }

    @Override
    public List<ParameterAnnotation> getParameterAnnotations() {
        return this.parameterAnnotations;
    }

    @Override
    public List<InstructionAnnotation> getInstructionAnnotations() {
        return this.instructionAnnotations;
    }

    @Override
    public List<TryCatchAnnotation> getTryCatchAnnotations() {
        return this.tryCatchAnnotations;
    }

    @Override
    public List<LocalVariableAnnotation> getLocalVariableAnnotations() {
        return this.localVariableAnnotations;
    }

    @Override
    public String getName() {
        return this.methodName;
    }

    @Override
    public boolean contains(Class<?> annotationClass) {
        return this.containsAnnotation(annotationClass) || this.containsTypeAnnotation(annotationClass) || this.containsParameterAnnotation(annotationClass) || this.containsInstructionAnnotation(annotationClass) || this.containsTryCatchAnnotation(annotationClass) || this.containsLocalVariableAnnotation(annotationClass);
    }

    @Override
    public boolean containsAnnotation(Class<?> annotationClass) {
        if (!this.hasAnnotations()) {
            return false;
        }
        return this.methodAnnotations.stream().anyMatch(annotation -> annotation.is(annotationClass));
    }

    @Override
    public boolean containsTypeAnnotation(Class<?> annotationClass) {
        if (!this.hasTypeAnnotations()) {
            return false;
        }
        return this.typeAnnotations.stream().anyMatch(annotation -> annotation.is(annotationClass));
    }

    @Override
    public boolean containsParameterAnnotation(Class<?> annotationClass) {
        if (!this.hasParameterAnnotations()) {
            return false;
        }
        return this.parameterAnnotations.stream().anyMatch(annotation -> annotation.is(annotationClass));
    }

    @Override
    public boolean containsInstructionAnnotation(Class<?> annotationClass) {
        if (!this.hasInstructionAnnotations()) {
            return false;
        }
        return this.instructionAnnotations.stream().anyMatch(annotation -> annotation.is(annotationClass));
    }

    @Override
    public boolean containsTryCatchAnnotation(Class<?> annotationClass) {
        if (!this.hasTryCatchAnnotations()) {
            return false;
        }
        return this.tryCatchAnnotations.stream().anyMatch(annotation -> annotation.is(annotationClass));
    }

    @Override
    public boolean containsLocalVariableAnnotation(Class<?> annotationClass) {
        if (!this.hasLocalVariableAnnotations()) {
            return false;
        }
        return this.localVariableAnnotations.stream().anyMatch(annotation -> annotation.is(annotationClass));
    }

    public void addAnnotation(ModAnnotation annotation) {
        this.methodAnnotations.add(annotation);
    }

    public void addTypeAnnotation(MethodTypeAnnotation annotation) {
        this.typeAnnotations.add(annotation);
    }

    public void addParameterAnnotation(MethodParameterAnnotation annotation) {
        this.parameterAnnotations.add(annotation);
    }

    public void addInstructionAnnotation(MethodInstructionAnnotation annotation) {
        this.instructionAnnotations.add(annotation);
    }

    public void addTryCatchAnnotation(MethodTryCatchAnnotation annotation) {
        this.tryCatchAnnotations.add(annotation);
    }

    public void addLocalVariableAnnotation(MethodLocalVariableAnnotation annotation) {
        this.localVariableAnnotations.add(annotation);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Name: ").append(this.methodName).append("\n");
        result.append("Descriptor: ").append(this.descriptor).append("\n");
        result.append("Class Name: ").append(this.className).append("\n");
        if (this.hasAnnotations()) {
            result.append("Annotations: \n");
            for (Annotation annotation : this.methodAnnotations) {
                result.append(" - ").append(annotation.toString().replace("\n", "\n   ")).append("\n");
            }
        }
        if (this.hasTypeAnnotations()) {
            result.append("Type Annotations: \n");
            for (TypeAnnotation typeAnnotation : this.typeAnnotations) {
                result.append(" - ").append(typeAnnotation.toString().replace("\n", "\n   ")).append("\n");
            }
        }
        if (this.hasParameterAnnotations()) {
            result.append("Parameter Annotations: \n");
            for (ParameterAnnotation parameterAnnotation : this.parameterAnnotations) {
                result.append(" - ").append(parameterAnnotation.toString().replace("\n", "\n   ")).append("\n");
            }
        }
        if (this.hasInstructionAnnotations()) {
            result.append("Instruction Annotations: \n");
            for (InstructionAnnotation instructionAnnotation : this.instructionAnnotations) {
                result.append(" - ").append(instructionAnnotation.toString().replace("\n", "\n   ")).append("\n");
            }
        }
        if (this.hasTryCatchAnnotations()) {
            result.append("Try Catch Annotations: \n");
            for (TryCatchAnnotation tryCatchAnnotation : this.tryCatchAnnotations) {
                result.append(" - ").append(tryCatchAnnotation.toString().replace("\n", "\n   ")).append("\n");
            }
        }
        if (this.hasLocalVariableAnnotations()) {
            result.append("Local Variables Annotations: \n");
            for (LocalVariableAnnotation localVariableAnnotation : this.localVariableAnnotations) {
                result.append(" - ").append(localVariableAnnotation.toString().replace("\n", "\n   ")).append("\n");
            }
        }
        return result.toString();
    }
}

