/*
 * Decompiled with CFR 0.152.
 */
package infinituum.void_lib.fabric.scanner.impl;

import infinituum.void_lib.fabric.scanner.api.Annotation;
import java.util.HashMap;
import java.util.Map;

public class ModAnnotation
implements Annotation {
    private final String className;
    private final Map<String, Object> fields;

    public ModAnnotation(String className) {
        this.className = className;
        this.fields = new HashMap<String, Object>();
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public boolean is(Class<?> clazz) {
        return clazz.getName().equals(this.className);
    }

    @Override
    public Map<String, Object> getFields() {
        return this.fields;
    }

    @Override
    public boolean hasFields() {
        return !this.fields.isEmpty();
    }

    @Override
    public boolean containsField(String fieldName) {
        return this.fields.containsKey(fieldName);
    }

    @Override
    public Object getField(String fieldName) {
        return this.fields.get(fieldName);
    }

    public void addField(String key, Object value) {
        this.fields.put(key, value);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Name: ").append(this.className).append("\n");
        if (this.hasFields()) {
            result.append("Fields: \n");
            for (Map.Entry<String, Object> fieldEntry : this.fields.entrySet()) {
                result.append(" - '").append(fieldEntry.getKey()).append("' : '").append(fieldEntry.getValue()).append("'\n");
            }
        }
        return result.toString();
    }
}

