/*
 * Decompiled with CFR 0.152.
 */
package infinituum.void_lib.api.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public final class UnsafeLoader {
    public static <T> T loadInstance(Class<T> clazz) {
        String className = clazz.getName();
        try {
            Constructor<T> constructor = clazz.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            if (clazz.getConstructors().length > 1) {
                throw new RuntimeException("Unsafely loaded class '" + className + "' can't define more than one constructor, only the default / parameterless constructor is accepted", e);
            }
            throw new RuntimeException("Unsafely loaded class '" + className + "' can't define a constructor that accepts more than 0 parameters, only the default / parameterless constructor is accepted", e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Could not instantiate '" + className + "'", e);
        }
    }

    public static <T> Class<T> loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> Class<T> loadClassNoInit(String className) {
        try {
            return Class.forName(className, false, null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> Class<T> loadClassNoInit(String className, ClassLoader classLoader) {
        try {
            return Class.forName(className, false, classLoader);
        }
        catch (Exception e) {
            return null;
        }
    }
}

