/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_10297;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.ICraftingHelpers;
import org.cyclops.cyclopscore.helper.IModHelpers;

public class CraftingHelpersCommon
implements ICraftingHelpers {
    private final IModHelpers modHelpers;
    private final LoadingCache<Triple<class_3956<?>, CacheableCraftingInventory, class_2960>, Optional<class_8786<? extends class_1860>>> CACHE_RECIPES = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build(new CacheLoader<Triple<class_3956<?>, CacheableCraftingInventory, class_2960>, Optional<class_8786<? extends class_1860>>>(){

        public Optional<class_8786<? extends class_1860>> load(Triple<class_3956<?>, CacheableCraftingInventory, class_2960> key) throws Exception {
            class_3218 world = CraftingHelpersCommon.this.modHelpers.getMinecraftHelpers().getCurrentServer().method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)((class_2960)key.getRight())));
            return world.method_64577().method_8132((class_3956)key.getLeft(), ((CacheableCraftingInventory)key.getMiddle()).getInventoryCrafting(), (class_1937)world);
        }
    });

    public CraftingHelpersCommon(IModHelpers modHelpers) {
        this.modHelpers = modHelpers;
    }

    @Override
    public class_1863 getRecipeManager() {
        return Objects.requireNonNull(this.modHelpers.getMinecraftHelpers().getCurrentServer().method_3847(class_1937.field_25179), "Server is still loading").method_64577();
    }

    @Override
    public <C extends class_9695, T extends class_1860<C>> Optional<class_8786<T>> getRecipe(class_3956<T> recipeType, class_5321<class_1860<?>> recipeName) {
        return Optional.ofNullable(this.getRecipeManager().method_59821(recipeType, recipeName));
    }

    @Override
    public <C extends class_9695, T extends class_1860<C>> Optional<class_8786<T>> findRecipe(class_3956<T> recipeType, C container, class_1937 world) {
        return ((class_1863)world.method_8433()).method_8132(recipeType, container, world);
    }

    @Override
    public <C extends class_9695, T extends class_1860<C>> List<class_8786<T>> findRecipes(class_3956<? extends T> recipeType) {
        return this.findRecipes(Objects.requireNonNull(this.modHelpers.getMinecraftHelpers().getCurrentServer().method_3847(class_1937.field_25179)), recipeType);
    }

    @Override
    public <C extends class_9695, T extends class_1860<C>> List<class_8786<T>> findRecipes(class_3218 world, class_3956<? extends T> recipeType) {
        return (List)world.method_64577().field_54638.method_64698(recipeType);
    }

    @Override
    public List<class_10297> getRecipeDisplays(class_3956<?> recipeType, class_5321<class_1860<?>> recipeName) {
        ArrayList displays = Lists.newArrayList();
        this.modHelpers.getMinecraftHelpers().getCurrentServer().method_30002().method_64577().method_64679(recipeName, displays::add);
        return displays;
    }

    @Override
    public List<Pair<class_2960, class_10297>> getRecipeDisplays(class_3956<?> recipeType, String recipeNameRegex) {
        ArrayList displays = Lists.newArrayList();
        for (Map.Entry entry : this.modHelpers.getMinecraftHelpers().getCurrentServer().method_30002().method_64577().field_54642.entrySet()) {
            if (!recipeNameRegex.isEmpty() && !((class_5321)entry.getKey()).method_29177().toString().matches(recipeNameRegex)) continue;
            for (class_1863.class_10288 display : (List)entry.getValue()) {
                displays.add(Pair.of((Object)display.comp_3250().comp_1932().method_29177(), (Object)display.comp_3249()));
            }
        }
        return displays;
    }

    @Override
    public <C extends class_9695, T extends class_1860<C>> Optional<class_8786<T>> findRecipeCached(class_3956<T> recipeType, C inventoryCrafting, class_1937 world, boolean uniqueInventory) {
        return (Optional)this.CACHE_RECIPES.getUnchecked((Object)Triple.of(recipeType, (Object)new CacheableCraftingInventory(inventoryCrafting, !uniqueInventory), (Object)world.method_27983().method_29177()));
    }

    public class CacheableCraftingInventory {
        private final class_9695 inventoryCrafting;

        public CacheableCraftingInventory(class_9695 inventoryCrafting, boolean copyInventory) {
            if (copyInventory) {
                int width = inventoryCrafting.method_59983();
                int height = 1;
                if (inventoryCrafting instanceof class_9694) {
                    width = ((class_9694)inventoryCrafting).method_59991();
                    height = ((class_9694)inventoryCrafting).method_59992();
                }
                int size = inventoryCrafting.method_59983();
                class_2371 items = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
                for (int i = 0; i < inventoryCrafting.method_59983(); ++i) {
                    items.set(i, (Object)inventoryCrafting.method_59984(i).method_7972());
                }
                this.inventoryCrafting = class_9694.method_59986((int)width, (int)height, (List)items);
            } else {
                this.inventoryCrafting = inventoryCrafting;
            }
        }

        public class_9695 getInventoryCrafting() {
            return this.inventoryCrafting;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof CacheableCraftingInventory)) {
                return false;
            }
            class_9695 otherInput = ((CacheableCraftingInventory)obj).getInventoryCrafting();
            class_9695 class_96952 = this.getInventoryCrafting();
            if (class_96952 instanceof class_9694) {
                class_9694 craftingInputThis = (class_9694)class_96952;
                if (!(otherInput instanceof class_9694)) return false;
                class_9694 craftingInputOther = (class_9694)otherInput;
                if (craftingInputThis.method_59991() != craftingInputOther.method_59991() || craftingInputThis.method_59992() != craftingInputOther.method_59992()) {
                    return false;
                }
            } else if (this.getInventoryCrafting().method_59983() != otherInput.method_59983()) {
                return false;
            }
            for (int i = 0; i < this.getInventoryCrafting().method_59983(); ++i) {
                if (class_1799.method_31577((class_1799)this.getInventoryCrafting().method_59984(i), (class_1799)otherInput.method_59984(i))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hash = 11 + this.getInventoryCrafting().method_59983();
            class_9695 class_96952 = this.getInventoryCrafting();
            if (class_96952 instanceof class_9694) {
                class_9694 craftingInput = (class_9694)class_96952;
                hash = 23 + 3 * craftingInput.method_59991() + 5 * craftingInput.method_59992();
            }
            for (int i = 0; i < this.getInventoryCrafting().method_59983(); ++i) {
                hash |= CraftingHelpersCommon.this.modHelpers.getItemStackHelpers().getItemStackHashCode(this.getInventoryCrafting().method_59984(i)) * i;
            }
            return hash;
        }
    }
}

