/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_3419;
import org.cyclops.cyclopscore.helper.IFluidHelpersFabric;
import org.jetbrains.annotations.Nullable;

public class FluidHelpersFabric
implements IFluidHelpersFabric {
    @Override
    public int getBucketVolume() {
        return 81000;
    }

    @Override
    @Nullable
    public StorageView<FluidVariant> getContainedFluid(@javax.annotation.Nullable Storage<FluidVariant> storage) {
        if (storage == null) {
            return null;
        }
        Iterator it = storage.nonEmptyIterator();
        return it.hasNext() ? (StorageView)it.next() : null;
    }

    @Override
    public long moveFluid(Storage<FluidVariant> source, Storage<FluidVariant> target, long amount, @Nullable class_1657 player, boolean simulate) {
        try (Transaction transaction = Transaction.openOuter();){
            StorageView<FluidVariant> fluidView = this.getContainedFluid(source);
            if (fluidView != null) {
                FluidVariant fluidVariant = (FluidVariant)fluidView.getResource();
                long extracted = source.extract((Object)fluidVariant, amount, (TransactionContext)transaction);
                long inserted = target.insert((Object)fluidVariant, extracted, (TransactionContext)transaction);
                if (!simulate) {
                    transaction.commit();
                    if (player != null) {
                        player.method_37908().method_43128(null, player.method_23317(), player.method_23318() + 0.5, player.method_23321(), FluidVariantAttributes.getEmptySound((FluidVariant)fluidVariant), class_3419.field_15245, 1.0f, 1.0f);
                    }
                } else {
                    transaction.close();
                }
                long l = inserted;
                return l;
            }
        }
        return 0L;
    }

    @Override
    public long moveFluid(Storage<FluidVariant> source, Storage<FluidVariant> target, long amount, @Nullable class_1657 player) {
        long movedSimulate = this.moveFluid(source, target, amount, player, true);
        if (movedSimulate > 0L) {
            return this.moveFluid(source, target, movedSimulate, player, false);
        }
        return 0L;
    }

    @Override
    public long moveFluid(Storage<FluidVariant> source, Storage<FluidVariant> target, long amount) {
        return this.moveFluid(source, target, amount, null);
    }
}

