/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory.slot;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class SlotArmor
extends Slot {
    private final EquipmentSlot armorType;
    private final Player player;

    public SlotArmor(Container inventory, int index, int x, int y, Player player, EquipmentSlot armorType) {
        super(inventory, index, x, y);
        this.armorType = armorType;
        this.player = player;
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean mayPlace(ItemStack itemStack) {
        return this.armorType == this.player.getEquipmentSlotForItem(itemStack);
    }

    public boolean mayPickup(Player player) {
        ItemStack itemstack = this.getItem();
        return !itemstack.isEmpty() && !player.isCreative() && EnchantmentHelper.has((ItemStack)itemstack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE) ? false : super.mayPickup(player);
    }

    public ResourceLocation getNoItemIcon() {
        return (ResourceLocation)InventoryMenu.TEXTURE_EMPTY_SLOTS.get(this.armorType);
    }
}

