/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.ICraftingHelpers;
import org.cyclops.cyclopscore.helper.IModHelpers;

public class CraftingHelpersCommon
implements ICraftingHelpers {
    private final IModHelpers modHelpers;
    private final LoadingCache<Triple<class_3956<?>, CacheableCraftingInventory, class_2960>, Optional<class_8786<? extends class_1860>>> CACHE_RECIPES = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build(new CacheLoader<Triple<class_3956<?>, CacheableCraftingInventory, class_2960>, Optional<class_8786<? extends class_1860>>>(){

        public Optional<class_8786<? extends class_1860>> load(Triple<class_3956<?>, CacheableCraftingInventory, class_2960> key) throws Exception {
            class_3218 world = CraftingHelpersCommon.this.modHelpers.getMinecraftHelpers().getCurrentServer().method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)((class_2960)key.getRight())));
            return world.method_8433().method_8132((class_3956)key.getLeft(), ((CacheableCraftingInventory)key.getMiddle()).getInventoryCrafting(), (class_1937)world);
        }
    });

    public CraftingHelpersCommon(IModHelpers modHelpers) {
        this.modHelpers = modHelpers;
    }

    @Override
    public <C extends class_9695, T extends class_1860<C>> List<class_8786<T>> findRecipes(class_1937 world, class_3956<? extends T> recipeType) {
        return world.method_8608() ? this.getClientRecipes(recipeType) : this.findServerRecipes((class_3218)world, recipeType);
    }

    @Override
    public class_1863 getRecipeManager() {
        return this.modHelpers.getMinecraftHelpers().isClientSide() ? class_310.method_1551().method_1562().method_2877() : Objects.requireNonNull(this.modHelpers.getMinecraftHelpers().getCurrentServer().method_3847(class_1937.field_25179), "Server is still loading").method_8433();
    }

    @Override
    public <C extends class_9695, T extends class_1860<C>> Optional<class_8786<T>> getServerRecipe(class_3956<T> recipeType, class_2960 recipeName) {
        return Optional.ofNullable(this.getRecipeManager().method_59821(recipeType, recipeName));
    }

    @Override
    public <C extends class_9695, T extends class_1860<C>> Optional<class_8786<T>> findServerRecipe(class_3956<T> recipeType, C container, class_1937 world) {
        return world.method_8433().method_8132(recipeType, container, world);
    }

    @Override
    public <C extends class_9695, T extends class_1860<C>> List<class_8786<T>> findServerRecipes(class_3956<? extends T> recipeType) {
        return this.findServerRecipes(Objects.requireNonNull(this.modHelpers.getMinecraftHelpers().getCurrentServer().method_3847(class_1937.field_25179)), recipeType);
    }

    @Override
    public <C extends class_9695, T extends class_1860<C>> List<class_8786<T>> findServerRecipes(class_3218 world, class_3956<? extends T> recipeType) {
        return world.method_8433().method_30027(recipeType);
    }

    @Override
    public <C extends class_9695, T extends class_1860<C>> Optional<class_8786<T>> getClientRecipe(class_3956<T> recipeType, class_2960 recipeName) {
        return Optional.ofNullable(this.getRecipeManager().method_59821(recipeType, recipeName));
    }

    @Override
    public <C extends class_9695, T extends class_1860<C>> List<class_8786<T>> getClientRecipes(class_3956<? extends T> recipeType) {
        return this.getRecipeManager().method_30027(recipeType);
    }

    @Override
    public <C extends class_9695, T extends class_1860<C>> class_8786<T> findClientRecipe(class_5455 registryAccess, class_1799 itemStack, class_3956<T> recipeType, int index) throws IllegalArgumentException {
        int indexAttempt = index;
        for (class_8786<T> recipe : this.getClientRecipes(recipeType)) {
            if (!class_1799.method_31577((class_1799)recipe.comp_1933().method_8110((class_7225.class_7874)registryAccess), (class_1799)itemStack) || indexAttempt-- != 0) continue;
            return recipe;
        }
        throw new IllegalArgumentException("Could not find recipe for " + String.valueOf(itemStack) + "::" + String.valueOf(itemStack.method_57353()) + " with index " + index);
    }

    @Override
    public <C extends class_9695, T extends class_1860<C>> Optional<class_8786<T>> findRecipeCached(class_3956<T> recipeType, C inventoryCrafting, class_1937 world, boolean uniqueInventory) {
        return (Optional)this.CACHE_RECIPES.getUnchecked((Object)Triple.of(recipeType, (Object)new CacheableCraftingInventory(inventoryCrafting, !uniqueInventory), (Object)world.method_27983().method_29177()));
    }

    public class CacheableCraftingInventory {
        private final class_9695 inventoryCrafting;

        public CacheableCraftingInventory(class_9695 inventoryCrafting, boolean copyInventory) {
            if (copyInventory) {
                int width = inventoryCrafting.method_59983();
                int height = 1;
                if (inventoryCrafting instanceof class_9694) {
                    width = ((class_9694)inventoryCrafting).method_59991();
                    height = ((class_9694)inventoryCrafting).method_59992();
                }
                int size = inventoryCrafting.method_59983();
                class_2371 items = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
                for (int i = 0; i < inventoryCrafting.method_59983(); ++i) {
                    items.set(i, (Object)inventoryCrafting.method_59984(i).method_7972());
                }
                this.inventoryCrafting = class_9694.method_59986((int)width, (int)height, (List)items);
            } else {
                this.inventoryCrafting = inventoryCrafting;
            }
        }

        public class_9695 getInventoryCrafting() {
            return this.inventoryCrafting;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof CacheableCraftingInventory)) {
                return false;
            }
            class_9695 otherInput = ((CacheableCraftingInventory)obj).getInventoryCrafting();
            class_9695 class_96952 = this.getInventoryCrafting();
            if (class_96952 instanceof class_9694) {
                class_9694 craftingInputThis = (class_9694)class_96952;
                if (!(otherInput instanceof class_9694)) return false;
                class_9694 craftingInputOther = (class_9694)otherInput;
                if (craftingInputThis.method_59991() != craftingInputOther.method_59991() || craftingInputThis.method_59992() != craftingInputOther.method_59992()) {
                    return false;
                }
            } else if (this.getInventoryCrafting().method_59983() != otherInput.method_59983()) {
                return false;
            }
            for (int i = 0; i < this.getInventoryCrafting().method_59983(); ++i) {
                if (class_1799.method_31577((class_1799)this.getInventoryCrafting().method_59984(i), (class_1799)otherInput.method_59984(i))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hash = 11 + this.getInventoryCrafting().method_59983();
            class_9695 class_96952 = this.getInventoryCrafting();
            if (class_96952 instanceof class_9694) {
                class_9694 craftingInput = (class_9694)class_96952;
                hash = 23 + 3 * craftingInput.method_59991() + 5 * craftingInput.method_59992();
            }
            for (int i = 0; i < this.getInventoryCrafting().method_59983(); ++i) {
                hash |= CraftingHelpersCommon.this.modHelpers.getItemStackHelpers().getItemStackHashCode(this.getInventoryCrafting().method_59984(i)) * i;
            }
            return hash;
        }
    }
}

