/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_465;
import net.minecraft.class_757;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.IGuiHelpers;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class GuiHelpersCommon
implements IGuiHelpers {
    protected final IModHelpers modHelpers;
    private static final List<Pair<Long, String>> COUNT_SCALES = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)1000000000000000000L, (Object)"E"), Pair.of((Object)1000000000000000L, (Object)"P"), Pair.of((Object)1000000000000L, (Object)"T"), Pair.of((Object)1000000000L, (Object)"G"), Pair.of((Object)1000000L, (Object)"M"), Pair.of((Object)1000L, (Object)"K")});

    public GuiHelpersCommon(IModHelpers modHelpers) {
        this.modHelpers = modHelpers;
    }

    @Override
    public int getSlotSize() {
        return 18;
    }

    @Override
    public int getSlotSizeInner() {
        return 16;
    }

    @Override
    public void renderProgressBar(class_332 gui, class_2960 texture, int x, int y, int width, int height, int textureX, int textureY, IGuiHelpers.ProgressDirection direction, int progress, int progressMax) {
        if (progressMax > 0 && progress > 0) {
            int offset;
            int scaledWidth = width;
            int scaledHeight = height;
            if (direction.getIncrementX() != 0) {
                scaledWidth = (int)((double)scaledWidth * ((double)progress / (double)progressMax));
            }
            if (direction.getIncrementY() != 0) {
                scaledHeight = (int)((double)scaledHeight * ((double)progress / (double)progressMax));
            }
            if (direction.getIncrementX() < 0) {
                offset = width - scaledWidth;
                x += offset;
                textureX += offset;
            }
            if (direction.getIncrementY() < 0) {
                offset = height - scaledHeight;
                y += offset;
                textureY += offset;
            }
            gui.method_25302(texture, x, y, textureX, textureY, scaledWidth, scaledHeight);
        }
    }

    @Override
    public void drawTooltip(class_465 gui, class_4587 poseStack, List<class_2561> lines, int x, int y) {
        int guiLeft = gui.field_2776;
        int guiTop = gui.field_2800;
        int width = gui.field_22789;
        int height = gui.field_22790;
        class_310 mc = class_310.method_1551();
        GL11.glDisable((int)2929);
        int tooltipWidth = 0;
        for (class_2561 line : lines) {
            int tempWidth = mc.field_1772.method_1727(line.getString());
            if (tempWidth <= tooltipWidth) continue;
            tooltipWidth = tempWidth;
        }
        int xStart = x + 12;
        int yStart = y - 12;
        int tooltipHeight = 8;
        if (lines.size() > 1) {
            tooltipHeight += 2 + (lines.size() - 1) * 10;
        }
        if (guiLeft + xStart + tooltipWidth + 6 > width) {
            xStart = width - tooltipWidth - guiLeft - 6;
        }
        if (guiTop + yStart + tooltipHeight + 6 > height) {
            yStart = height - tooltipHeight - guiTop - 6;
        }
        this.drawTooltipBackground(poseStack, xStart, yStart, tooltipWidth, tooltipHeight);
        class_4587 matrixstack = new class_4587();
        class_4597.class_4598 irendertypebuffer$impl = class_4597.method_22991((class_9799)new class_9799(1536));
        matrixstack.method_22904(0.0, 0.0, 300.0);
        Matrix4f matrix4f = matrixstack.method_23760().method_23761();
        for (int stringIndex = 0; stringIndex < lines.size(); ++stringIndex) {
            class_2561 line = lines.get(stringIndex);
            line = stringIndex == 0 ? class_2561.method_43470((String)("\u00a7" + Integer.toHexString(15))).method_10852(line) : class_2561.method_43470((String)"\u00a77").method_10852(line);
            mc.field_1772.method_22942(line.method_30937(), (float)(xStart + guiLeft), (float)(yStart + guiTop), -1, true, matrix4f, (class_4597)irendertypebuffer$impl, class_327.class_6415.field_33993, 0, 0xF000F0);
            if (stringIndex == 0) {
                yStart += 2;
            }
            yStart += 10;
        }
        irendertypebuffer$impl.method_22993();
        GL11.glEnable((int)2929);
    }

    @Override
    public void drawTooltipBackground(class_4587 poseStack, int xStart, int yStart, int tooltipWidth, int tooltipHeight) {
        float zLevel = 300.0f;
        int color1 = -267386864;
        this.fillGradient(poseStack, xStart - 3, yStart - 4, xStart + tooltipWidth + 3, yStart - 3, color1, color1, zLevel);
        this.fillGradient(poseStack, xStart - 3, yStart + tooltipHeight + 3, xStart + tooltipWidth + 3, yStart + tooltipHeight + 4, color1, color1, zLevel);
        this.fillGradient(poseStack, xStart - 3, yStart - 3, xStart + tooltipWidth + 3, yStart + tooltipHeight + 3, color1, color1, zLevel);
        this.fillGradient(poseStack, xStart - 4, yStart - 3, xStart - 3, yStart + tooltipHeight + 3, color1, color1, zLevel);
        this.fillGradient(poseStack, xStart + tooltipWidth + 3, yStart - 3, xStart + tooltipWidth + 4, yStart + tooltipHeight + 3, color1, color1, zLevel);
        int color2 = 0x505000FF;
        int color3 = (color2 & 0xFEFEFE) >> 1 | color2 & 0xFF000000;
        this.fillGradient(poseStack, xStart - 3, yStart - 3 + 1, xStart - 3 + 1, yStart + tooltipHeight + 3 - 1, color2, color3, zLevel);
        this.fillGradient(poseStack, xStart + tooltipWidth + 2, yStart - 3 + 1, xStart + tooltipWidth + 3, yStart + tooltipHeight + 3 - 1, color2, color3, zLevel);
        this.fillGradient(poseStack, xStart - 3, yStart - 3, xStart + tooltipWidth + 3, yStart - 3 + 1, color2, color2, zLevel);
        this.fillGradient(poseStack, xStart - 3, yStart + tooltipHeight + 2, xStart + tooltipWidth + 3, yStart + tooltipHeight + 3, color3, color3, zLevel);
    }

    @Override
    public void fillGradient(class_4587 poseStack, int left, int top, int right, int bottom, int startColor, int endColor, float zLevel) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tesselator = class_289.method_1348();
        class_287 bufferbuilder = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        Matrix4f matrix = poseStack.method_23760().method_23761();
        bufferbuilder.method_22918(matrix, (float)right, (float)top, zLevel).method_22915(f1, f2, f3, f);
        bufferbuilder.method_22918(matrix, (float)left, (float)top, zLevel).method_22915(f1, f2, f3, f);
        bufferbuilder.method_22918(matrix, (float)left, (float)bottom, zLevel).method_22915(f5, f6, f7, f4);
        bufferbuilder.method_22918(matrix, (float)right, (float)bottom, zLevel).method_22915(f5, f6, f7, f4);
        class_286.method_43433((class_9801)bufferbuilder.method_60800());
        RenderSystem.disableBlend();
    }

    @Override
    public void renderTooltipOptional(class_465 gui, class_4587 poseStack, int x, int y, int width, int height, int mouseX, int mouseY, Supplier<Optional<List<class_2561>>> linesSupplier) {
        if (this.modHelpers.getRenderHelpers().isPointInRegion(x, y, width, height, mouseX - gui.field_2776, mouseY - gui.field_2800)) {
            linesSupplier.get().ifPresent(lines -> this.drawTooltip(gui, poseStack, (List<class_2561>)lines, mouseX - gui.field_2776, mouseY - gui.field_2800));
        }
    }

    @Override
    public void renderTooltip(class_465 gui, class_4587 poseStack, int x, int y, int width, int height, int mouseX, int mouseY, Supplier<List<class_2561>> linesSupplier) {
        this.renderTooltipOptional(gui, poseStack, x, y, width, height, mouseX, mouseY, () -> Optional.of((List)linesSupplier.get()));
    }

    @Override
    public String quantityToScaledString(long quantity) {
        for (Pair<Long, String> countScale : COUNT_SCALES) {
            long mod;
            long scale = (Long)countScale.getLeft();
            if (quantity < scale) continue;
            long division = quantity / scale;
            Object divisionString = String.valueOf(division);
            if (division < 10L) {
                long mod2 = quantity % scale;
                if (mod2 > 0L) {
                    long digits = mod2 * 100L / scale;
                    divisionString = (String)divisionString + "." + (digits < 10L ? "0" : "") + String.valueOf(digits);
                }
            } else if (division < 100L && (mod = quantity % scale) > 0L) {
                long digits = mod * 10L / scale;
                divisionString = (String)divisionString + "." + String.valueOf(digits);
            }
            return (String)divisionString + (String)countScale.getRight();
        }
        return String.valueOf(quantity);
    }
}

