/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.init;

import com.mojang.brigadier.CommandDispatcher;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_7157;
import org.cyclops.cyclopscore.config.ConfigHandlerFabric;
import org.cyclops.cyclopscore.config.ConfigurableTypesFabric;
import org.cyclops.cyclopscore.helper.IModHelpersFabric;
import org.cyclops.cyclopscore.helper.ModBaseCommon;
import org.cyclops.cyclopscore.helper.ModHelpersFabric;
import org.cyclops.cyclopscore.modcompat.ModCompatLoader;
import org.cyclops.cyclopscore.modcompat.forgeconfig.ModCompatForgeConfig;
import org.cyclops.cyclopscore.network.PacketHandlerFabric;
import org.cyclops.cyclopscore.proxy.ICommonProxyCommon;
import org.jetbrains.annotations.Nullable;

public abstract class ModBaseFabric<T extends ModBaseFabric<T>>
extends ModBaseCommon<T>
implements ModInitializer {
    private boolean loaded = false;
    private final ICommonProxyCommon proxy = this.getModHelpers().getMinecraftHelpers().isClientSide() ? this.constructClientProxy() : this.constructCommonProxy();
    private final ConfigHandlerFabric configHandler = this.constructConfigHandler();
    private final PacketHandlerFabric packetHandler = this.constructPacketHandler();

    public ModBaseFabric(String modId, Consumer<T> instanceSetter) {
        super(modId, instanceSetter);
        this.onConfigsRegister(this.getConfigHandler());
        this.getConfigHandler().loadModInit();
        this.loadModCompats(this.getModCompatLoader());
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void onInitialize() {
        this.loaded = true;
        this.getConfigHandler().loadSetup();
        this.getConfigHandler().loadForgeRegistries();
        this.getConfigHandler().loadForgeRegistriesFilled();
        CommandRegistrationCallback.EVENT.register(this::onRegisterCommands);
        ICommonProxyCommon proxy = this.getProxy();
        if (proxy != null) {
            proxy.registerEventHooks();
            proxy.registerTickHandlers();
            if (this.getModHelpers().getMinecraftHelpers().isClientSide()) {
                proxy.registerRenderers();
            }
            proxy.registerPackets(this.getPacketHandlerCommon());
        }
    }

    protected ConfigHandlerFabric constructConfigHandler() {
        return new ConfigHandlerFabric(this);
    }

    @Override
    public IModHelpersFabric getModHelpers() {
        return ModHelpersFabric.INSTANCE;
    }

    @Override
    public ICommonProxyCommon getProxy() {
        return this.proxy;
    }

    @Override
    public ConfigHandlerFabric getConfigHandler() {
        return this.configHandler;
    }

    protected PacketHandlerFabric constructPacketHandler() {
        return new PacketHandlerFabric(this);
    }

    @Override
    public PacketHandlerFabric getPacketHandlerCommon() {
        return this.packetHandler;
    }

    @Override
    protected void loadModCompats(ModCompatLoader modCompatLoader) {
        super.loadModCompats(modCompatLoader);
        modCompatLoader.addModCompat(new ModCompatForgeConfig());
    }

    protected void onRegisterCommands(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register(this.constructBaseCommand(environment, registryAccess));
    }

    @Nullable
    public static ModBaseFabric get(String modId) {
        return (ModBaseFabric)ModBaseCommon.getCommon(modId);
    }

    public static Map<String, ModBaseFabric<?>> getMods() {
        return ModBaseCommon.getCommonMods();
    }

    static {
        ConfigurableTypesFabric.load();
    }
}

