/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network.packet.debug;

import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.helper.CyclopsCoreInstance;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.cyclopscore.network.packet.debug.PingPongPacketSync;

public class PingPongPacketAsync<T extends PingPongPacketAsync<T>>
extends PacketCodec<T> {
    public static final CustomPacketPayload.Type<PingPongPacketAsync> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cyclopscore", (String)"ping_pong_async"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PingPongPacketAsync> CODEC = PingPongPacketAsync.getCodec(PingPongPacketAsync::new);
    @CodecField
    protected int remaining;

    public PingPongPacketAsync() {
        super(TYPE);
    }

    public PingPongPacketAsync(int remaining) {
        this();
        this.remaining = remaining;
    }

    public PingPongPacketAsync(CustomPacketPayload.Type<T> type) {
        super(type);
    }

    public PingPongPacketAsync(CustomPacketPayload.Type<T> type, int remaining) {
        super(type);
        this.remaining = remaining;
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    protected void log(Player player, String message) {
        player.sendSystemMessage((Component)Component.literal((String)message));
    }

    protected PingPongPacketAsync newPacket() {
        return new PingPongPacketSync(this.remaining - 1);
    }

    @Override
    public void actionClient(Level level, Player player) {
        if (this.remaining > 0) {
            CyclopsCoreInstance.MOD.getPacketHandlerCommon().sendToServer(this.newPacket());
        }
        this.log(player, String.format("[PING %s] Fields: %s", this.remaining, this.toString()));
    }

    @Override
    public void actionServer(Level level, ServerPlayer player) {
        if (this.remaining > 0) {
            CyclopsCoreInstance.MOD.getPacketHandlerCommon().sendToPlayer(this.newPacket(), player);
        }
        this.log((Player)player, String.format("[PONG %s] Fields: %s", this.remaining, this.toString()));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        List fields = (List)this.fieldCache.get(null);
        for (Field field : fields) {
            sb.append(" ");
            sb.append(field);
            sb.append("=");
            try {
                sb.append(field.get(this));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                sb.append("ERROR(" + e.getMessage() + ")");
            }
        }
        return sb.toString();
    }
}

