/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.component.button;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonExtended;
import org.cyclops.cyclopscore.client.gui.image.IImage;

public class ButtonImage
extends ButtonExtended {
    private IImage[] images;
    private final int offsetX;
    private final int offsetY;

    public ButtonImage(int x, int y, int width, int height, Component narrationMessage, Button.OnPress pressCallback, IImage[] images, boolean background, int offsetX, int offsetY) {
        super(x, y, width, height, narrationMessage, pressCallback, background);
        this.images = images;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public ButtonImage(int x, int y, Component narrationMessage, Button.OnPress pressCallback, IImage ... images) {
        this(x, y, images[0].getWidth(), images[0].getHeight(), narrationMessage, pressCallback, images, false, 0, 0);
    }

    public ButtonImage(int x, int y, int width, int height, Component narrationMessage, Button.OnPress pressCallback, boolean background, IImage image, int offsetX, int offsetY) {
        this(x, y, width, height, narrationMessage, pressCallback, new IImage[]{image}, background, offsetX, offsetY);
    }

    public ButtonImage(int x, int y, Component narrationMessage, Button.OnPress pressCallback, IImage image) {
        this(x, y, image.getWidth(), image.getHeight(), narrationMessage, pressCallback, false, image, 0, 0);
    }

    @Override
    protected void drawButtonInner(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (IImage image : this.images) {
            image.draw(guiGraphics, this.getX() + this.offsetX, this.getY() + this.offsetY);
        }
    }

    public void setImage(IImage image) {
        this.images[0] = image;
    }

    public void setImages(IImage[] images) {
        this.images = images;
    }
}

