/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurabletypeaction;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.config.ConfigurableTypesForge;
import org.cyclops.cyclopscore.config.configurabletypeaction.ConfigurableTypeActionCommon;
import org.cyclops.cyclopscore.config.extendedconfig.FluidConfigForge;
import org.cyclops.cyclopscore.init.ModBaseForge;

@Mod.EventBusSubscriber(modid="cyclopscore", bus=Mod.EventBusSubscriber.Bus.MOD)
public class FluidActionForge<M extends ModBaseForge>
extends ConfigurableTypeActionCommon<FluidConfigForge<M>, ForgeFlowingFluid.Properties, M> {
    private final Multimap<String, Pair<FluidConfigForge, Callable<?>>> registryEntriesHolder = Multimaps.newListMultimap((Map)Maps.newHashMap(), (Supplier)new Supplier<List<Pair<FluidConfigForge, Callable<?>>>>(this){

        public List<Pair<FluidConfigForge, Callable<?>>> get() {
            return Lists.newArrayList();
        }
    });
    private boolean registryEventPassed = false;

    @Override
    public void onRegisterForge(FluidConfigForge config) {
        if (this.registryEventPassed) {
            throw new IllegalStateException(String.format("Tried registering %s after its registration event.", config.getNamedId()));
        }
        this.registryEntriesHolder.put((Object)BuiltInRegistries.FLUID.key().toString(), (Object)Pair.of((Object)config, () -> {
            config.onForgeRegistered();
            return null;
        }));
    }

    @SubscribeEvent
    public static void onRegistryEvent(RegisterEvent event) {
        ((FluidActionForge)ConfigurableTypesForge.FLUID.getConfigurableTypeAction()).onRegistryEventInner(event);
    }

    public void onRegistryEventInner(RegisterEvent event) {
        if (event.getRegistryKey() == BuiltInRegistries.FLUID.key()) {
            this.registryEventPassed = true;
            IForgeRegistry registry = event.getForgeRegistry();
            this.registryEntriesHolder.get((Object)registry.getRegistryKey().toString()).forEach(pair -> {
                FluidConfigForge config = (FluidConfigForge)pair.getLeft();
                ForgeFlowingFluid.Properties instance = (ForgeFlowingFluid.Properties)config.getInstance();
                java.util.function.Supplier still = (java.util.function.Supplier)ObfuscationReflectionHelper.getPrivateValue(ForgeFlowingFluid.Properties.class, (Object)instance, (String)"still");
                java.util.function.Supplier flowing = (java.util.function.Supplier)ObfuscationReflectionHelper.getPrivateValue(ForgeFlowingFluid.Properties.class, (Object)instance, (String)"flowing");
                this.registerFluid((IForgeRegistry<Fluid>)registry, event, still, ResourceLocation.fromNamespaceAndPath((String)((ModBaseForge)config.getMod()).getModId(), (String)config.getNamedId()));
                this.registerFluid((IForgeRegistry<Fluid>)registry, event, flowing, ResourceLocation.fromNamespaceAndPath((String)((ModBaseForge)config.getMod()).getModId(), (String)(config.getNamedId() + "_flowing")));
                try {
                    if (pair.getRight() != null) {
                        ((Callable)pair.getRight()).call();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } else if (event.getRegistryKey() == ForgeRegistries.FLUID_TYPES.getKey()) {
            this.registryEntriesHolder.get((Object)BuiltInRegistries.FLUID.key().toString()).forEach(pair -> {
                FluidConfigForge config = (FluidConfigForge)pair.getLeft();
                ForgeFlowingFluid.Properties instance = (ForgeFlowingFluid.Properties)config.getInstance();
                java.util.function.Supplier fluidType = (java.util.function.Supplier)ObfuscationReflectionHelper.getPrivateValue(ForgeFlowingFluid.Properties.class, (Object)instance, (String)"fluidType");
                event.register(event.getForgeRegistry().getRegistryKey(), ResourceLocation.fromNamespaceAndPath((String)((ModBaseForge)config.getMod()).getModId(), (String)config.getNamedId()), fluidType);
            });
        }
    }

    protected void registerFluid(IForgeRegistry<Fluid> registry, RegisterEvent event, java.util.function.Supplier<Fluid> fluidSupplier, ResourceLocation name) {
        registry.register(name, (Object)fluidSupplier.get());
    }
}

