/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IRenderHelpersForge;
import org.cyclops.cyclopscore.helper.RenderHelpersCommon;

public class RenderHelpersForge
extends RenderHelpersCommon
implements IRenderHelpersForge {
    private final IModHelpers modHelpers;

    public RenderHelpersForge(IModHelpers modHelpers) {
        this.modHelpers = modHelpers;
    }

    @Override
    public TextureAtlasSprite getFluidIcon(Fluid fluid, Direction side) {
        return this.getFluidIcon(new FluidStack(fluid, 1000), side);
    }

    @Override
    public TextureAtlasSprite getFluidIcon(FluidStack fluid, Direction side) {
        if (side == null) {
            side = Direction.UP;
        }
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        TextureAtlasSprite icon = (TextureAtlasSprite)this.getBlockTextureGetter().apply((Object)renderProperties.getFlowingTexture(fluid));
        if (icon == null || side == Direction.UP || side == Direction.DOWN) {
            icon = (TextureAtlasSprite)this.getBlockTextureGetter().apply((Object)renderProperties.getStillTexture(fluid));
        }
        return icon;
    }

    @Override
    public void renderFluidContext(FluidStack fluid, PoseStack matrixStack, IRenderHelpersForge.IFluidContextRender render) {
        if (fluid != null && fluid.getAmount() > 0) {
            matrixStack.pushPose();
            RenderSystem.enableBlend();
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            Minecraft.getInstance().getTextureManager().bindForSetup(TextureAtlas.LOCATION_BLOCKS);
            render.render();
            RenderSystem.disableBlend();
            matrixStack.popPose();
        }
    }

    @Override
    public Triple<Float, Float, Float> getFluidVertexBufferColor(FluidStack fluidStack) {
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        int color = renderProperties.getTintColor(fluidStack);
        return this.modHelpers.getBaseHelpers().intToRGB(color);
    }

    @Override
    public int getFluidBakedQuadColor(FluidStack fluidStack) {
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        Triple<Float, Float, Float> colorParts = this.modHelpers.getBaseHelpers().intToRGB(renderProperties.getTintColor(fluidStack));
        return this.modHelpers.getBaseHelpers().RGBAToInt((int)(((Float)colorParts.getRight()).floatValue() * 255.0f), (int)(((Float)colorParts.getMiddle()).floatValue() * 255.0f), (int)(((Float)colorParts.getLeft()).floatValue() * 255.0f), 255);
    }
}

