/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.advancement.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.cyclops.cyclopscore.advancement.criterion.ICriterionInstanceTestable;

public class GuiContainerOpenTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final Codec<Instance> CODEC = RecordCodecBuilder.create(p_311401_ -> p_311401_.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Instance::player), (App)Codec.STRING.optionalFieldOf("container_class").forGetter(Instance::containerClass)).apply((Applicative)p_311401_, Instance::new));

    public Codec<Instance> codec() {
        return CODEC;
    }

    public void trigger(ServerPlayer pPlayer, Predicate<Instance> pTestTrigger) {
        super.trigger(pPlayer, pTestTrigger);
    }

    public record Instance(Optional<ContextAwarePredicate> player, Optional<String> containerClass) implements SimpleCriterionTrigger.SimpleInstance,
    ICriterionInstanceTestable<AbstractContainerMenu>
    {
        @Override
        public boolean test(ServerPlayer player, AbstractContainerMenu container) {
            return this.containerClass.map(className -> {
                Class<?> clazz;
                try {
                    clazz = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Could not find the container class with name '" + className + "'");
                }
                return clazz != null && clazz.isInstance(container);
            }).orElse(true);
        }
    }
}

