/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.helper.RecipeHelpers;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.IInfoBookRegistry;
import org.cyclops.cyclopscore.infobook.InfoBookParser;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.pageelement.AdvancementRewards;
import org.cyclops.cyclopscore.init.ModBaseNeoForge;

public class InfoBookRegistry
implements IInfoBookRegistry {
    private final Map<IInfoBook, String> bookPaths = Maps.newIdentityHashMap();
    private final Map<IInfoBook, InfoSection> bookRoots = Maps.newIdentityHashMap();
    private final Queue<SectionInjection> sectionInjections = new LinkedBlockingQueue<SectionInjection>();

    public InfoBookRegistry() {
        NeoForge.EVENT_BUS.addListener(this::onPlayerLoggedIn);
        NeoForge.EVENT_BUS.addListener(this::onServerStarted);
    }

    @Override
    public void registerInfoBook(IInfoBook infoBook, String path) {
        this.bookPaths.put(infoBook, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSection(ModBaseNeoForge<?> mod, IInfoBook infoBook, String parentSection, String sectionPath) {
        Queue<SectionInjection> queue = this.sectionInjections;
        synchronized (queue) {
            this.sectionInjections.add(new SectionInjection(Objects.requireNonNull(mod), infoBook, parentSection, sectionPath));
        }
    }

    @Override
    public InfoSection getRoot(IInfoBook infoBook) {
        return this.bookRoots.get(infoBook);
    }

    public static void onClientTagsLoadedStatic(TagsUpdatedEvent event) {
        AdvancementRewards.reset();
    }

    public static void onServerStartedStatic(ServerStartedEvent event) {
        if (event.getServer().isDedicatedServer()) {
            AdvancementRewards.reset();
        }
    }

    public void onPlayerLoggedIn(ClientPlayerNetworkEvent.LoggingIn event) {
        RecipeHelpers.reset();
        this.initializeAllBooks(false);
    }

    public void onServerStarted(ServerStartedEvent event) {
        if (event.getServer().isDedicatedServer()) {
            this.initializeAllBooks(false);
        }
    }

    @Override
    public void initializeAllBooks(boolean reload) {
        for (Map.Entry<IInfoBook, String> entry : this.bookPaths.entrySet()) {
            if (!reload) {
                entry.getKey().getMod().log(Level.INFO, "Loading infobook " + entry.getValue());
            }
            this.bookRoots.put(entry.getKey(), InfoBookParser.initializeInfoBook(entry.getKey().getMod(), entry.getKey(), entry.getValue(), null));
            entry.getKey().setCurrentSection(null);
        }
        for (SectionInjection sectionInjection : this.sectionInjections) {
            InfoSection section = sectionInjection.getInfoBook().getSection(sectionInjection.getParentSection());
            if (section == null) {
                throw new IllegalArgumentException(String.format("Could not find section '%s' in infobook '%s'.", sectionInjection.getParentSection(), sectionInjection.getInfoBook()));
            }
            section.registerSection(InfoBookParser.initializeInfoBook(sectionInjection.getMod(), sectionInjection.getInfoBook(), sectionInjection.getSectionPath(), section));
        }
    }

    static {
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, InfoBookRegistry::onClientTagsLoadedStatic);
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, InfoBookRegistry::onServerStartedStatic);
    }

    private static final class SectionInjection {
        private final ModBaseNeoForge<?> mod;
        private final IInfoBook infoBook;
        private final String parentSection;
        private final String sectionPath;

        private SectionInjection(ModBaseNeoForge<?> mod, IInfoBook infoBook, String parentSection, String sectionPath) {
            this.mod = mod;
            this.infoBook = Objects.requireNonNull(infoBook);
            this.parentSection = parentSection;
            this.sectionPath = sectionPath;
        }

        public ModBaseNeoForge<?> getMod() {
            return this.mod;
        }

        public IInfoBook getInfoBook() {
            return this.infoBook;
        }

        public String getParentSection() {
            return this.parentSection;
        }

        public String getSectionPath() {
            return this.sectionPath;
        }
    }
}

