/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.metadata;

import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.cyclops.cyclopscore.CyclopsCoreNeoForge;
import org.cyclops.cyclopscore.helper.IModHelpers;

public interface IRegistryExportable {
    public JsonObject export();

    public String getName();

    public static JsonObject serializeItemStack(ItemStack itemStack) {
        JsonObject object = new JsonObject();
        object.addProperty("item", BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).toString());
        object.addProperty("count", (Number)itemStack.getCount());
        String componentsString = "{}";
        try {
            componentsString = IRegistryExportable.componentsToString((HolderLookup.Provider)ServerLifecycleHooks.getCurrentServer().registryAccess(), itemStack.getComponentsPatch());
        }
        catch (IllegalStateException e) {
            CyclopsCoreNeoForge.clog(e.getMessage());
        }
        if (!"{}".equals(componentsString)) {
            object.addProperty("components", componentsString);
        }
        return object;
    }

    public static JsonObject serializeFluidStack(FluidStack fluidStack) {
        JsonObject object = new JsonObject();
        object.addProperty("fluid", BuiltInRegistries.FLUID.getKey((Object)fluidStack.getFluid()).toString());
        object.addProperty("amount", (Number)fluidStack.getAmount());
        String componentsString = "{}";
        try {
            componentsString = IRegistryExportable.componentsToString((HolderLookup.Provider)ServerLifecycleHooks.getCurrentServer().registryAccess(), fluidStack.getComponentsPatch());
        }
        catch (IllegalStateException e) {
            CyclopsCoreNeoForge.clog(e.getMessage());
        }
        if (!"{}".equals(componentsString)) {
            object.addProperty("components", componentsString);
        }
        return object;
    }

    public static String componentsToString(HolderLookup.Provider lookupProvider, DataComponentPatch components) {
        return ((Tag)DataComponentPatch.CODEC.encodeStart((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)components).getOrThrow()).toString();
    }

    public static ItemStack getRecipeOutput(RecipeHolder<?> recipe) {
        return IModHelpers.get().getMinecraftHelpers().getRecipeOutput(recipe, (Level)IModHelpers.get().getMinecraftHelpers().getCurrentServer().overworld());
    }
}

