/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.metadata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import org.cyclops.cyclopscore.metadata.IRegistryExportable;
import org.cyclops.cyclopscore.metadata.RegistryExportableRecipeAbstract;

public class RegistryExportableCraftingRecipe
extends RegistryExportableRecipeAbstract<RecipeType<CraftingRecipe>, CraftingRecipe, CraftingInput> {
    protected RegistryExportableCraftingRecipe() {
        super(() -> RecipeType.CRAFTING);
    }

    @Override
    public JsonObject serializeRecipe(RecipeHolder<CraftingRecipe> recipe) {
        JsonObject object = new JsonObject();
        List inputs = ((CraftingRecipe)recipe.value()).placementInfo().ingredients();
        JsonArray arrayInputs = new JsonArray();
        for (Ingredient input : inputs) {
            JsonArray arrayInputAlternatives = new JsonArray();
            for (Holder inputAlternative : input.getValues()) {
                arrayInputAlternatives.add((JsonElement)IRegistryExportable.serializeItemStack(new ItemStack((ItemLike)inputAlternative.value())));
            }
            arrayInputs.add((JsonElement)arrayInputAlternatives);
        }
        object.addProperty("id", recipe.id().toString());
        object.add("input", (JsonElement)arrayInputs);
        object.add("output", (JsonElement)IRegistryExportable.serializeItemStack(IRegistryExportable.getRecipeOutput(recipe)));
        if (recipe.value() instanceof ShapedRecipe) {
            object.addProperty("width", (Number)((ShapedRecipe)recipe.value()).getWidth());
            object.addProperty("height", (Number)((ShapedRecipe)recipe.value()).getHeight());
        }
        return object;
    }
}

