/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.nbt.path.parse;

import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.cyclops.cyclopscore.nbt.path.INbtPathExpression;
import org.cyclops.cyclopscore.nbt.path.NbtPathExpressionMatches;
import org.cyclops.cyclopscore.nbt.path.navigate.INbtPathNavigation;
import org.cyclops.cyclopscore.nbt.path.navigate.NbtPathNavigationLeafWildcard;
import org.cyclops.cyclopscore.nbt.path.navigate.NbtPathNavigationLinkWildcard;
import org.cyclops.cyclopscore.nbt.path.parse.INbtPathExpressionParseHandler;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionExecutionContext;

public class NbtPathExpressionParseHandlerAllChildren
implements INbtPathExpressionParseHandler {
    @Override
    @Nullable
    public INbtPathExpressionParseHandler.HandleResult handlePrefixOf(String nbtPathExpression, int pos) {
        if (nbtPathExpression.charAt(pos) != '*') {
            return INbtPathExpressionParseHandler.HandleResult.INVALID;
        }
        return new INbtPathExpressionParseHandler.HandleResult(Expression.INSTANCE, 1);
    }

    public static class Expression
    implements INbtPathExpression {
        public static final Expression INSTANCE = new Expression();

        @Override
        public NbtPathExpressionMatches matchContexts(Stream<NbtPathExpressionExecutionContext> executionContexts) {
            return new NbtPathExpressionMatches(executionContexts.flatMap(executionContext -> {
                Tag nbt = executionContext.getCurrentTag();
                if (nbt.getId() == 9) {
                    ListTag tag = (ListTag)nbt;
                    return StreamSupport.stream(tag.spliterator(), false).map(subTag -> new NbtPathExpressionExecutionContext((Tag)subTag, (NbtPathExpressionExecutionContext)executionContext));
                }
                if (nbt.getId() == 10) {
                    CompoundTag tag = (CompoundTag)nbt;
                    return tag.keySet().stream().map(key -> new NbtPathExpressionExecutionContext(tag.get(key), (NbtPathExpressionExecutionContext)executionContext));
                }
                return null;
            }).filter(Objects::nonNull));
        }

        @Override
        public INbtPathNavigation asNavigation(@Nullable INbtPathNavigation child) {
            return child == null ? NbtPathNavigationLeafWildcard.INSTANCE : new NbtPathNavigationLinkWildcard(child);
        }
    }
}

