/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigHandler;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.ConfigurablePropertyData;
import org.cyclops.cyclopscore.config.IConfigInitializer;
import org.cyclops.cyclopscore.config.ModConfigLocation;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigCommon;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigForge;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigRegistry;
import org.cyclops.cyclopscore.config.extendedconfig.FluidConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.init.IModBase;
import org.cyclops.cyclopscore.init.ModBase;

public class ConfigHandlerNeoForge
extends ConfigHandler {
    private final Multimap<String, Pair<ExtendedConfigRegistry<?, ?, ?>, Callable<?>>> registryEntriesHolder = Multimaps.newListMultimap((Map)Maps.newHashMap(), (com.google.common.base.Supplier)new com.google.common.base.Supplier<List<Pair<ExtendedConfigRegistry<?, ?, ?>, Callable<?>>>>(this){

        public List<Pair<ExtendedConfigRegistry<?, ?, ?>, Callable<?>>> get() {
            return Lists.newArrayList();
        }
    });
    private final Multimap<String, Pair<ExtendedConfigForge<?, ?>, Callable<?>>> registryEntriesHolderOld = Multimaps.newListMultimap((Map)Maps.newHashMap(), (com.google.common.base.Supplier)new com.google.common.base.Supplier<List<Pair<ExtendedConfigForge<?, ?>, Callable<?>>>>(this){

        public List<Pair<ExtendedConfigForge<?, ?>, Callable<?>>> get() {
            return Lists.newArrayList();
        }
    });
    private Set<String> registryEventPassed = Sets.newHashSet();

    public ConfigHandlerNeoForge(ModBase<?> mod) {
        super(mod);
        mod.getModEventBus().register((Object)this);
    }

    public Multimap<String, Pair<ExtendedConfigRegistry<?, ?, ?>, Callable<?>>> getRegistryEntriesHolder() {
        return this.registryEntriesHolder;
    }

    public Set<String> getRegistryEventPassed() {
        return this.registryEventPassed;
    }

    @Override
    public <V> void registerToRegistry(Registry<? super V> registry, ExtendedConfigRegistry<?, V, ?> config, @Nullable Callable<?> callback) {
        if (this.registryEventPassed.contains(registry.key().toString())) {
            throw new IllegalStateException(String.format("Tried registering %s after its registration event.", config.getNamedId()));
        }
        this.registryEntriesHolder.put((Object)registry.key().toString(), (Object)Pair.of(config, callback));
    }

    @Deprecated
    public <V> void registerToRegistry(Registry<? super V> registry, ExtendedConfigForge<?, V> config, @Nullable Callable<?> callback) {
        if (this.registryEventPassed.contains(registry.key().toString())) {
            throw new IllegalStateException(String.format("Tried registering %s after its registration event.", config.getNamedId()));
        }
        this.registryEntriesHolderOld.put((Object)registry.key().toString(), (Object)Pair.of(config, callback));
    }

    @SubscribeEvent
    public void onLoad(ModConfigEvent.Loading configEvent) {
        this.getMod().log(Level.TRACE, "Load config");
        this.syncProcessedConfigs(configEvent.getConfig(), false);
    }

    @SubscribeEvent
    public void onReload(ModConfigEvent.Reloading configEvent) {
        this.getMod().log(Level.TRACE, "Reload config");
        this.syncProcessedConfigs(configEvent.getConfig(), true);
    }

    @SubscribeEvent
    public void onRegistryEvent(RegisterEvent event) {
        this.registryEventPassed.add(event.getRegistryKey().toString());
        Registry registry = event.getRegistry();
        this.registryEntriesHolder.get((Object)registry.key().toString()).forEach(pair -> {
            ExtendedConfigRegistry config = (ExtendedConfigRegistry)pair.getLeft();
            event.register(registry.key(), ConfigHandlerNeoForge.getConfigId(config), (Supplier)((com.google.common.base.Supplier)config::getInstance));
            try {
                if (pair.getRight() != null) {
                    ((Callable)pair.getRight()).call();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.registryEntriesHolderOld.get((Object)registry.key().toString()).forEach(pair -> {
            ExtendedConfigForge config = (ExtendedConfigForge)pair.getLeft();
            event.register(registry.key(), ConfigHandlerNeoForge.getConfigId(config), (Supplier)((com.google.common.base.Supplier)config::getInstance));
            try {
                if (pair.getRight() != null) {
                    ((Callable)pair.getRight()).call();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void initialize(Collection<IConfigInitializer> configInitializers) {
        EnumMap<ModConfig.Type, ModConfigSpec.Builder> configBuilders = new EnumMap<ModConfig.Type, ModConfigSpec.Builder>(ModConfig.Type.class);
        for (ExtendedConfigCommon extendedConfigCommon : this.getConfigurables()) {
            ModConfigSpec.Builder configBuilder = (ModConfigSpec.Builder)configBuilders.get(ModConfig.Type.COMMON);
            if (configBuilder == null) {
                configBuilder = new ModConfigSpec.Builder();
                configBuilders.put(ModConfig.Type.COMMON, configBuilder);
            }
            this.addCategory(extendedConfigCommon.getConfigurableType().getCategory());
            for (ConfigurablePropertyData<?> configProperty : extendedConfigCommon.configProperties.values()) {
                ModConfigSpec.Builder configBuilderProperty = (ModConfigSpec.Builder)configBuilders.get(ConfigHandlerNeoForge.modConfigLocationToType(configProperty.getConfigLocation()));
                if (configBuilderProperty == null) {
                    configBuilderProperty = new ModConfigSpec.Builder();
                    configBuilders.put(ConfigHandlerNeoForge.modConfigLocationToType(configProperty.getConfigLocation()), configBuilderProperty);
                }
                this.getCategories().add(configProperty.getCategory());
                this.onConfigPropertyInit(configProperty, configBuilder);
                if (!configProperty.isCommandable()) continue;
                this.getCommandableProperties().put(configProperty.getName(), configProperty);
            }
        }
        for (IConfigInitializer iConfigInitializer : configInitializers) {
            iConfigInitializer.initializeConfig(configBuilders);
        }
        for (Map.Entry entry : configBuilders.entrySet()) {
            ModLoadingContext.get().getActiveContainer().registerConfig((ModConfig.Type)entry.getKey(), (IConfigSpec)((ModConfigSpec.Builder)entry.getValue()).build());
        }
    }

    protected <T> void onConfigPropertyInit(ConfigurablePropertyData<T> configPropertyData, ModConfigSpec.Builder configBuilder) {
        configBuilder.push(configPropertyData.category);
        if (configPropertyData.requiresWorldRestart) {
            configBuilder.worldRestart();
        }
        ModConfigSpec.ConfigValue configProperty = configBuilder.comment(configPropertyData.comment).translation(configPropertyData.getLanguageKey()).define(configPropertyData.name, configPropertyData.defaultValue);
        configPropertyData.setConfigProperty((Supplier<Object>)configProperty, newValue -> {
            configProperty.set(newValue);
            configProperty.save();
        });
        configBuilder.pop();
    }

    public void syncProcessedConfigs(ModConfig config, boolean reload) {
        for (ExtendedConfigCommon extendedConfigCommon : this.getConfigurables()) {
            for (ConfigurablePropertyData<?> configProperty : extendedConfigCommon.configProperties.values()) {
                configProperty.saveToField();
                extendedConfigCommon.onConfigPropertyReload(configProperty, reload);
            }
        }
    }

    public static ModConfigLocation modConfigTypeToLocation(ModConfig.Type modConfigType) {
        switch (modConfigType) {
            case COMMON: {
                return ModConfigLocation.COMMON;
            }
            case CLIENT: {
                return ModConfigLocation.CLIENT;
            }
            case SERVER: {
                return ModConfigLocation.SERVER;
            }
            case STARTUP: {
                return ModConfigLocation.STARTUP;
            }
        }
        return null;
    }

    public static ModConfig.Type modConfigLocationToType(ModConfigLocation modConfigLocation) {
        switch (modConfigLocation) {
            case COMMON: {
                return ModConfig.Type.COMMON;
            }
            case CLIENT: {
                return ModConfig.Type.CLIENT;
            }
            case SERVER: {
                return ModConfig.Type.SERVER;
            }
            case STARTUP: {
                return ModConfig.Type.STARTUP;
            }
        }
        return null;
    }

    @Override
    public void generateConfigProperties(ExtendedConfigCommon<?, ?, ?> config) throws IllegalArgumentException, IllegalAccessException {
        super.generateConfigProperties(config);
        for (Field field : ConfigHandlerNeoForge.getAllFields(config.getClass())) {
            String string;
            if (!field.isAnnotationPresent(ConfigurableProperty.class)) continue;
            ConfigurableProperty annotation = field.getAnnotation(ConfigurableProperty.class);
            IModBase iModBase = this.getMod();
            String string2 = annotation.category();
            if (config instanceof ExtendedConfig) {
                ExtendedConfig configLegacy = (ExtendedConfig)config;
                string = configLegacy.getConfigPropertyPrefixPublic(annotation);
            } else if (config instanceof BlockConfig) {
                BlockConfig blockConfig = (BlockConfig)config;
                string = blockConfig.getConfigPropertyPrefixPublic(annotation);
            } else if (config instanceof ItemConfig) {
                ItemConfig itemConfig = (ItemConfig)config;
                string = itemConfig.getConfigPropertyPrefixPublic(annotation);
            } else {
                string = this.getConfigPropertyLegacyPrefix(config, annotation);
            }
            ConfigurablePropertyData<Object> configProperty = new ConfigurablePropertyData<Object>(iModBase, string2, string + "." + field.getName(), field.get(null), annotation.comment(), annotation.isCommandable(), ConfigHandlerNeoForge.modConfigTypeToLocation(annotation.configLocation()), field, annotation.requiresWorldRestart(), annotation.requiresMcRestart(), annotation.showInGui(), annotation.minimalValue(), annotation.maximalValue());
            config.configProperties.put(configProperty.getName(), configProperty);
        }
    }

    protected String getConfigPropertyLegacyPrefix(ExtendedConfigCommon<?, ?, ?> config, ConfigurableProperty annotation) {
        return annotation.namedId().isEmpty() ? config.getNamedId() : annotation.namedId();
    }

    @Override
    public void addToConfigDictionary(ExtendedConfigCommon<?, ?, ?> e) {
        super.addToConfigDictionary(e);
        if (e instanceof FluidConfig) {
            this.getConfigDictionary().put(e.getNamedId(), e);
        }
    }
}

