/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.neoforge.common.CommonHooks;

public class EnchantmentHelpers {
    public static boolean doesEnchantApply(ItemStack itemStack, Holder<Enchantment> enchantment) {
        return EnchantmentHelpers.getEnchantmentLevel(itemStack, enchantment) > 0;
    }

    public static int getEnchantmentLevel(ItemStack itemStack, Holder<Enchantment> enchantment) {
        ItemEnchantments enchantments = itemStack.getAllEnchantments(CommonHooks.resolveLookup((ResourceKey)Registries.ENCHANTMENT));
        return enchantments.getLevel(enchantment);
    }

    public static DataComponentType<ItemEnchantments> getComponentType(ItemStack itemStack) {
        return itemStack.is(Items.ENCHANTED_BOOK) ? DataComponents.STORED_ENCHANTMENTS : DataComponents.ENCHANTMENTS;
    }

    public static void setEnchantmentLevel(ItemStack itemStack, Holder<Enchantment> enchantment, int level) {
        DataComponentType<ItemEnchantments> datacomponenttype = EnchantmentHelpers.getComponentType(itemStack);
        ItemEnchantments enchantments = (ItemEnchantments)itemStack.get(datacomponenttype);
        ItemEnchantments.Mutable enchantmentsMutable = new ItemEnchantments.Mutable(enchantments);
        enchantmentsMutable.set(enchantment, level);
        itemStack.set(datacomponenttype, (Object)enchantmentsMutable.toImmutable());
    }

    public static void runIterationOnItem(ItemStack itemStack, EnchantmentVisitor visitor) {
        ItemEnchantments itemenchantments = (ItemEnchantments)itemStack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        HolderLookup.RegistryLookup lookup = CommonHooks.resolveLookup((ResourceKey)Registries.ENCHANTMENT);
        if (lookup != null) {
            itemenchantments = itemStack.getAllEnchantments(lookup);
        }
        for (Object2IntMap.Entry entry : itemenchantments.entrySet()) {
            visitor.accept((Holder<Enchantment>)((Holder)entry.getKey()), entry.getIntValue());
        }
    }

    public static interface EnchantmentVisitor {
        public void accept(Holder<Enchantment> var1, int var2);
    }
}

