/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.cyclops.cyclopscore.client.particle.ParticleDropColoredData;

public class ParticleDropColored
extends SingleQuadParticle {
    public static final SingleQuadParticle.Layer LAYER = new SingleQuadParticle.Layer(true, TextureAtlas.LOCATION_PARTICLES, RenderPipelines.TRANSLUCENT_PARTICLE);
    private int bobTimer;

    public ParticleDropColored(ParticleDropColoredData data, ClientLevel world, double x, double y, double z, TextureAtlasSprite sprite) {
        super(world, x, y, z, sprite);
        this.zd = 0.0;
        this.yd = 0.0;
        this.xd = 0.0;
        this.rCol = data.getRed();
        this.gCol = data.getGreen();
        this.bCol = data.getBlue();
        this.setSize(0.01f, 0.01f);
        this.gravity = 0.06f;
        this.bobTimer = 40;
        this.lifetime = (int)(64.0 / (Math.random() * 0.8 + 0.2));
        this.zd = 0.0;
        this.yd = 0.0;
        this.xd = 0.0;
    }

    protected SingleQuadParticle.Layer getLayer() {
        return LAYER;
    }

    public void tick() {
        BlockPos blockPos;
        BlockState blockState;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.yd -= (double)this.gravity;
        if (this.bobTimer-- > 0) {
            this.xd *= 0.02;
            this.yd *= 0.02;
            this.zd *= 0.02;
        }
        this.move(this.xd, this.yd, this.zd);
        this.xd *= (double)0.98f;
        this.yd *= (double)0.98f;
        this.zd *= (double)0.98f;
        if (this.lifetime-- <= 0) {
            this.remove();
        }
        if (this.onGround) {
            this.xd *= (double)0.7f;
            this.zd *= (double)0.7f;
        }
        if ((blockState = this.level.getBlockState(blockPos = new BlockPos(Mth.floor((double)this.x), Mth.floor((double)this.y), Mth.floor((double)this.z)))).liquid() || blockState.isSolid()) {
            double d0;
            float h = 1.0f;
            FluidState fluidState = this.level.getFluidState(blockPos);
            if (!fluidState.isEmpty()) {
                h = (float)fluidState.getAmount() / 8.0f;
            }
            if (this.y < (d0 = (double)((float)(Mth.floor((double)this.y) + 1) - h))) {
                this.remove();
            }
        }
    }
}

