/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.joml.Quaternionfc;

public abstract class RenderBlockEntityModel<T extends CyclopsBlockEntity, S extends BlockEntityRenderState, M>
implements BlockEntityRenderer<T, S> {
    protected final M model;
    private final Material material;

    public RenderBlockEntityModel(M model, Material material) {
        this.model = model;
        this.material = material;
    }

    public M getModel() {
        return this.model;
    }

    public Material getMaterial() {
        return this.material;
    }

    public Function<ResourceLocation, RenderType> getRenderTypeGetter() {
        return RenderType::entityCutout;
    }

    protected void preRotate(S renderState, PoseStack matrixStack) {
        matrixStack.translate(0.5f, 0.5f, 0.5f);
    }

    protected void postRotate(S renderState, PoseStack matrixStack) {
        matrixStack.translate(-0.5f, -0.5f, -0.5f);
    }

    public void submit(S renderState, PoseStack matrixStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        Direction direction = ((IRotationRenderState)renderState).rotation();
        matrixStack.pushPose();
        matrixStack.translate(0.0f, 1.0f, 1.0f);
        matrixStack.scale(1.0f, -1.0f, -1.0f);
        this.preRotate(renderState, matrixStack);
        int rotation = 0;
        if (direction == Direction.SOUTH) {
            rotation = 180;
        }
        if (direction == Direction.NORTH) {
            rotation = 0;
        }
        if (direction == Direction.EAST) {
            rotation = 90;
        }
        if (direction == Direction.WEST) {
            rotation = -90;
        }
        matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)rotation));
        this.postRotate(renderState, matrixStack);
        this.submitModel(renderState, this.getModel(), matrixStack, nodeCollector, cameraRenderState);
        matrixStack.popPose();
    }

    protected abstract void submitModel(S var1, M var2, PoseStack var3, SubmitNodeCollector var4, CameraRenderState var5);

    public static interface IRotationRenderState {
        public Direction rotation();
    }
}

