/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.persist.world;

import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.cyclops.cyclopscore.init.ModBaseNeoForge;

public abstract class WorldStorage<T extends WorldStorage>
extends SavedData {
    public void afterLoad() {
    }

    public void beforeSave() {
    }

    public static abstract class Access<T extends WorldStorage<T>> {
        private final SavedDataType<T> savedDataType;
        protected final ModBaseNeoForge<?> mod;

        public Access(SavedDataType<T> savedDataType, ModBaseNeoForge<?> mod) {
            this.savedDataType = savedDataType;
            this.mod = mod;
        }

        public T get(MinecraftServer server) {
            return (T)((Object)((WorldStorage)server.getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(this.savedDataType)));
        }

        public T get() {
            return this.get(ServerLifecycleHooks.getCurrentServer());
        }

        public void onStartedEvent(ServerStartedEvent event) {
            T data = this.get(event.getServer());
            ((WorldStorage)((Object)data)).afterLoad();
        }

        public void onStoppingEvent(ServerStoppingEvent event) {
            T data = this.get(event.getServer());
            ((WorldStorage)((Object)data)).beforeSave();
        }
    }
}

