/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.component;

import java.awt.Point;
import java.awt.Rectangle;
import javax.annotation.Nullable;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_6382;
import org.cyclops.cyclopscore.helper.IModHelpers;

public class WidgetScrollBar
extends class_339 {
    private static final class_2960 SCROLLER_SPRITE = class_2960.method_60656((String)"container/creative_inventory/scroller");
    private static final class_2960 SCROLLER_DISABLED_SPRITE = class_2960.method_60656((String)"container/creative_inventory/scroller_disabled");
    private static final int SCROLL_BUTTON_HEIGHT = 15;
    private static final int SCROLL_BUTTON_WIDTH = 12;
    private final int height;
    @Nullable
    private final IScrollCallback scrollCallback;
    @Nullable
    private Rectangle scollRegion;
    private int totalRows;
    private int visibleRows;
    private float currentScroll;
    private boolean isScrolling;
    private boolean wasClicking;

    public WidgetScrollBar(int x, int y, int height, class_2561 narrationMessage, @Nullable IScrollCallback scrollCallback, int visibleRows) {
        this(x, y, height, narrationMessage, scrollCallback, visibleRows, null);
    }

    public WidgetScrollBar(int x, int y, int height, class_2561 narrationMessage, @Nullable IScrollCallback scrollCallback, int visibleRows, Rectangle scollRegion) {
        super(x, y, 12, height, narrationMessage);
        this.height = height;
        this.scrollCallback = scrollCallback;
        this.scollRegion = scollRegion;
        this.currentScroll = 0.0f;
        this.isScrolling = false;
        this.wasClicking = false;
        this.setVisibleRows(visibleRows);
    }

    public void setScollRegion(@Nullable Rectangle scollRegion) {
        this.scollRegion = scollRegion;
    }

    public boolean isMouseOverRegion(double x, double y) {
        if (this.scollRegion != null && IModHelpers.get().getRenderHelpers().isPointInRegion(this.scollRegion, new Point((int)x, (int)y))) {
            return true;
        }
        return super.method_25405(x, y);
    }

    public float getCurrentScroll() {
        return this.currentScroll;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollY != 0.0 && this.needsScrollBars()) {
            this.scrollRelative(scrollY);
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int mouseButton, double offsetX, double offsetY) {
        boolean flag = mouseButton == 0 || mouseButton == 1;
        int xMax = this.method_46426() + 14;
        int yMax = this.method_46427() + this.height;
        if (!this.needsScrollBars()) {
            this.scrollTo(0.0f);
            return true;
        }
        if (!this.wasClicking && flag && mouseX >= (double)this.method_46426() && mouseY >= (double)this.method_46427() && mouseX < (double)xMax && mouseY < (double)yMax) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouseY - (double)this.method_46427()) - 7.5f) / ((float)(yMax - this.method_46427()) - 15.0f);
            this.currentScroll = class_3532.method_15363((float)this.currentScroll, (float)0.0f, (float)1.0f);
            this.scrollTo(this.currentScroll);
            return true;
        }
        return false;
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int scrollX = this.method_46426();
        int scrollMinY = this.method_46427();
        int scrollMaxY = scrollMinY + this.height;
        guiGraphics.method_52706(class_10799.field_56883, this.needsScrollBars() ? SCROLLER_SPRITE : SCROLLER_DISABLED_SPRITE, scrollX, scrollMinY + (int)((float)(scrollMaxY - scrollMinY - 15 - 2) * this.currentScroll), 12, 15);
    }

    protected boolean needsScrollBars() {
        return this.getTotalRows() > this.getVisibleRows();
    }

    protected int getScrollStep() {
        return this.getTotalRows() - this.getVisibleRows();
    }

    public void scrollRelative(double step) {
        float scroll = (float)((double)this.currentScroll - step / (double)this.getScrollStep());
        scroll = class_3532.method_15363((float)scroll, (float)0.0f, (float)1.0f);
        this.scrollTo(scroll);
    }

    public void scrollTo(float scroll) {
        this.scrollTo(scroll, true);
    }

    public void scrollTo(float scroll, boolean invokeCallback) {
        this.currentScroll = Math.max(0.0f, scroll);
        if (invokeCallback && this.scrollCallback != null) {
            int firstRow = (int)((double)(scroll * (float)this.getScrollStep()) + 0.5);
            this.scrollCallback.onScroll(firstRow);
        }
    }

    public void setFirstRow(int firstRow, boolean invokeCallback) {
        float scroll = (float)firstRow / (float)this.getScrollStep();
        scroll = class_3532.method_15363((float)scroll, (float)0.0f, (float)1.0f);
        this.scrollTo(scroll, invokeCallback);
    }

    public int getTotalRows() {
        return this.totalRows;
    }

    public void setTotalRows(int totalRows) {
        this.totalRows = totalRows;
    }

    public int getVisibleRows() {
        return this.visibleRows;
    }

    public void setVisibleRows(int visibleRows) {
        this.visibleRows = visibleRows;
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    public static interface IScrollCallback {
        public void onScroll(int var1);
    }
}

