/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.container;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_10799;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3917;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import org.cyclops.cyclopscore.helper.CyclopsCoreInstance;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifiable;
import org.cyclops.cyclopscore.inventory.container.ContainerExtended;
import org.cyclops.cyclopscore.network.packet.ButtonClickPacket;

public abstract class ContainerScreenExtended<T extends ContainerExtended>
extends class_465<T>
implements IValueNotifiable {
    private final IModHelpers modHelpers;
    protected T container;
    protected class_2960 texture;
    protected int offsetX = 0;
    protected int offsetY = 0;

    public ContainerScreenExtended(T container, class_1661 playerInventory, class_2561 title) {
        super(container, playerInventory, title);
        ((ContainerExtended)container).setGuiValueListener(this);
        this.modHelpers = IModHelpers.get();
        this.container = container;
        this.texture = this.constructGuiTexture();
    }

    protected abstract class_2960 constructGuiTexture();

    public class_2960 getGuiTexture() {
        return this.texture;
    }

    public void method_25426() {
        this.field_2792 = this.getBaseXSize() + this.offsetX * 2;
        this.field_2779 = this.getBaseYSize() + this.offsetY * 2;
        super.method_25426();
    }

    public final void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(guiGraphics, mouseX, mouseY, partialTicks);
        this.drawCurrentScreen(guiGraphics, mouseX, mouseY, partialTicks);
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    protected void drawCurrentScreen(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
    }

    protected int getBaseXSize() {
        return 176;
    }

    protected int getBaseYSize() {
        return 166;
    }

    protected void method_2389(class_332 guiGraphics, float f, int x, int y) {
        guiGraphics.method_25290(class_10799.field_56883, this.getGuiTexture(), this.field_2776 + this.offsetX, this.field_2800 + this.offsetY, 0.0f, 0.0f, this.field_2792 - 2 * this.offsetX, this.field_2779 - 2 * this.offsetY, 256, 256);
    }

    public boolean isHovering(class_1735 slotIn, double mouseX, double mouseY) {
        return this.method_2378(slotIn.field_7873 - 1, slotIn.field_7872 - 1, 18, 18, mouseX, mouseY);
    }

    public boolean method_2378(int left, int top, int right, int bottom, double pointX, double pointY) {
        return this.modHelpers.getRenderHelpers().isPointInRegion(left, top, right, bottom, pointX - (double)this.field_2776, pointY - (double)this.field_2800);
    }

    public boolean isPointInRegion(Rectangle region, Point mouse) {
        return this.method_2378(region.x, region.y, region.width, region.height, mouse.x, mouse.y);
    }

    public void drawTooltip(List<class_2561> lines, class_332 guiGraphics, int x, int y) {
        IModHelpers.get().getGuiHelpers().drawTooltip(this, guiGraphics, lines, x, y);
    }

    protected class_4185.class_4241 createServerPressable(String buttonId, @Nullable class_4185.class_4241 clientPressable) {
        return button -> {
            if (clientPressable != null) {
                clientPressable.onPress(button);
            }
            if (((ContainerExtended)this.method_17577()).onButtonClick(buttonId)) {
                CyclopsCoreInstance.MOD.getPacketHandler().sendToServer(new ButtonClickPacket(buttonId));
            }
        };
    }

    @Override
    public void onUpdate(int valueId, class_2487 value) {
    }

    protected void refreshValues() {
        for (int id : ((ContainerExtended)this.method_17577()).getValueIds()) {
            this.onUpdate(id, ((ContainerExtended)this.method_17577()).getValue(id));
        }
    }

    public int getGuiLeftTotal() {
        return this.field_2776 + this.offsetX;
    }

    public int getGuiTopTotal() {
        return this.field_2800 + this.offsetY;
    }

    @Override
    public class_3917<?> getValueNotifiableType() {
        return ((ContainerExtended)this.method_17577()).method_17358();
    }
}

