/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.command.CommandConfig;
import org.cyclops.cyclopscore.config.ConfigHandlerCommon;
import org.cyclops.cyclopscore.config.extendedconfig.CreativeModeTabConfigCommon;
import org.cyclops.cyclopscore.helper.LoggerHelper;
import org.cyclops.cyclopscore.init.IModBase;
import org.cyclops.cyclopscore.init.RegistryManager;
import org.cyclops.cyclopscore.modcompat.ModCompatLoader;
import org.cyclops.cyclopscore.proxy.IClientProxyCommon;
import org.cyclops.cyclopscore.proxy.ICommonProxyCommon;

public abstract class ModBaseCommon<T extends ModBaseCommon<T>>
implements IModBase {
    private static final Map<String, ModBaseCommon<?>> MOD_BASES = Maps.newConcurrentMap();
    private final String modId;
    private final LoggerHelper loggerHelper;
    private final RegistryManager registryManager;
    private final ModCompatLoader modCompatLoader;
    @Nullable
    private class_1761 defaultCreativeTab = null;
    private final List<Pair<class_1799, class_1761.class_7705>> defaultCreativeTabEntries = Lists.newArrayList();

    public ModBaseCommon(String modId, Consumer<T> instanceSetter) {
        instanceSetter.accept(this);
        MOD_BASES.put(modId, this);
        this.modId = modId;
        this.loggerHelper = this.constructLoggerHelper();
        this.registryManager = this.constructRegistryManager();
        this.modCompatLoader = this.constructModCompatLoader();
    }

    @Override
    public String getModId() {
        return this.modId;
    }

    @Override
    public LoggerHelper getLoggerHelper() {
        return this.loggerHelper;
    }

    protected LoggerHelper constructLoggerHelper() {
        return new LoggerHelper(this.getModId());
    }

    protected RegistryManager constructRegistryManager() {
        return new RegistryManager();
    }

    @Override
    public RegistryManager getRegistryManager() {
        return this.registryManager;
    }

    protected abstract IClientProxyCommon constructClientProxy();

    protected abstract ICommonProxyCommon constructCommonProxy();

    @Override
    public ModCompatLoader getModCompatLoader() {
        return this.modCompatLoader;
    }

    protected ModCompatLoader constructModCompatLoader() {
        return new ModCompatLoader(this);
    }

    protected void loadModCompats(ModCompatLoader modCompatLoader) {
    }

    protected LiteralArgumentBuilder<class_2168> constructBaseCommand(class_2170.class_5364 selection, class_7157 context) {
        LiteralArgumentBuilder root = class_2170.method_9247((String)this.getModId());
        root.then(CommandConfig.make(this));
        return root;
    }

    @Override
    @Nullable
    public class_1761 getDefaultCreativeTab() {
        return this.defaultCreativeTab;
    }

    @Override
    public List<Pair<class_1799, class_1761.class_7705>> getDefaultCreativeTabEntries() {
        return this.defaultCreativeTabEntries;
    }

    @Override
    public void registerDefaultCreativeTabEntry(class_1799 itemStack, class_1761.class_7705 visibility) {
        if (this.defaultCreativeTabEntries == null) {
            throw new IllegalStateException("Tried to register default tab entries after the CreativeModeTabEvent.BuildContents event");
        }
        if (itemStack.method_7947() != 1) {
            throw new IllegalStateException("Tried to register default tab entries with a non-1-count ItemStack");
        }
        this.defaultCreativeTabEntries.add((Pair<class_1799, class_1761.class_7705>)Pair.of((Object)itemStack, (Object)visibility));
    }

    protected CreativeModeTabConfigCommon<ModBaseCommon<T>> constructDefaultCreativeModeTabConfig() {
        return new CreativeModeTabConfigCommon<ModBaseCommon<T>>(this, "default", config -> {
            this.defaultCreativeTab = this.constructDefaultCreativeModeTab(class_1761.method_47307((class_1761.class_7915)class_1761.class_7915.field_41049, (int)0)).method_47324();
            return this.defaultCreativeTab;
        });
    }

    protected class_1761.class_7913 constructDefaultCreativeModeTab(class_1761.class_7913 builder) {
        return builder.method_47321((class_2561)class_2561.method_43471((String)("itemGroup." + this.getModId()))).method_47320(() -> new class_1799((class_1935)class_1802.field_8077)).method_47317((parameters, output) -> {
            for (Pair<class_1799, class_1761.class_7705> entry : this.defaultCreativeTabEntries) {
                output.method_45417((class_1799)entry.getLeft(), (class_1761.class_7705)entry.getRight());
            }
        });
    }

    protected boolean hasDefaultCreativeModeTab() {
        return true;
    }

    protected void onConfigsRegister(ConfigHandlerCommon configHandler) {
        if (this.hasDefaultCreativeModeTab()) {
            this.getConfigHandler().addConfigurable(this.constructDefaultCreativeModeTabConfig());
        }
    }

    public Class<?>[] getGameTestClasses() {
        return new Class[0];
    }

    public String toString() {
        return this.getModId();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        return object == this;
    }

    @Nullable
    public static ModBaseCommon getCommon(String modId) {
        return MOD_BASES.get(modId);
    }

    public static Map<String, ModBaseCommon<?>> getCommonMods() {
        return MOD_BASES;
    }
}

