/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.base.Function;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_10799;
import net.minecraft.class_1087;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_638;
import net.minecraft.class_702;
import net.minecraft.class_703;
import net.minecraft.class_727;
import net.minecraft.class_773;
import net.minecraft.class_776;
import net.minecraft.class_9848;
import org.cyclops.cyclopscore.helper.IRenderHelpers;
import org.joml.Matrix3x2f;

public class RenderHelpersCommon
implements IRenderHelpers {
    private static final Random rand = new Random();
    private static final Function<class_2960, class_1058> TEXTURE_GETTER = location -> (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(location);

    @Override
    public void bindTexture(GpuTextureView texture) {
        RenderSystem.setShaderTexture((int)0, (GpuTextureView)texture);
    }

    @Override
    public void emitParticle(class_703 particle) {
        class_310.method_1551().field_1713.method_3058(particle);
    }

    @Override
    public void drawScaledString(class_332 guiGraphics, class_327 fontRenderer, String string, int x, int y, float scale, int color, boolean shadow, class_327.class_6415 displayMode) {
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().translate((float)x, (float)y, (Matrix3x2f)guiGraphics.method_51448());
        guiGraphics.method_51448().scale(scale, scale, (Matrix3x2f)guiGraphics.method_51448());
        guiGraphics.method_51433(fontRenderer, string, 0, 0, color, shadow);
        guiGraphics.method_51448().popMatrix();
    }

    @Override
    public void drawScaledCenteredString(class_332 guiGraphics, class_327 fontRenderer, String string, int x, int y, int maxWidth, int color, boolean shadow, class_327.class_6415 displayMode) {
        this.drawScaledCenteredString(guiGraphics, fontRenderer, string, x, y, maxWidth, 1.0f, maxWidth, color, shadow, displayMode);
    }

    @Override
    public void drawScaledCenteredString(class_332 guiGraphics, class_327 fontRenderer, String string, int x, int y, int width, float originalScale, int maxWidth, int color, boolean shadow, class_327.class_6415 displayMode) {
        float originalWidth = (float)fontRenderer.method_1727(string) * originalScale;
        float scale = Math.min(originalScale, (float)maxWidth / originalWidth * originalScale);
        this.drawScaledCenteredString(guiGraphics, fontRenderer, string, x, y, width, scale, color, shadow, displayMode);
    }

    @Override
    public void drawScaledCenteredString(class_332 guiGraphics, class_327 fontRenderer, String string, int x, int y, int width, float scale, int color, boolean shadow, class_327.class_6415 displayMode) {
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().scale(scale, scale, (Matrix3x2f)guiGraphics.method_51448());
        int titleLength = fontRenderer.method_1727(string);
        Objects.requireNonNull(fontRenderer);
        int titleHeight = 9;
        guiGraphics.method_51433(fontRenderer, string, Math.round((float)(x + width / 2) / scale - (float)(titleLength / 2)), Math.round((float)y / scale - (float)(titleHeight / 2)), color, false);
        guiGraphics.method_51448().popMatrix();
    }

    @Override
    public class_1087 getBakedModel(class_2680 blockState) {
        class_310 mc = class_310.method_1551();
        class_776 blockRendererDispatcher = mc.method_1541();
        class_773 blockModelShapes = blockRendererDispatcher.method_3351();
        return blockModelShapes.method_3335(blockState);
    }

    @Override
    public class_1087 getDynamicBakedModel(class_1937 world, class_2338 pos) {
        return this.getBakedModel(world.method_8320(pos));
    }

    @Override
    public void addBlockHitEffects(class_702 particleManager, class_638 world, class_2680 blockState, class_2338 pos, class_2350 side) {
        if (blockState.method_26217() != class_2464.field_11455) {
            int i = pos.method_10263();
            int j = pos.method_10264();
            int k = pos.method_10260();
            float f = 0.1f;
            class_238 bb = blockState.method_26218((class_1922)world, pos).method_1107();
            double d0 = (double)i + rand.nextDouble() * (bb.field_1320 - bb.field_1323 - (double)(f * 2.0f)) + (double)f + bb.field_1323;
            double d1 = (double)j + rand.nextDouble() * (bb.field_1325 - bb.field_1322 - (double)(f * 2.0f)) + (double)f + bb.field_1322;
            double d2 = (double)k + rand.nextDouble() * (bb.field_1324 - bb.field_1321 - (double)(f * 2.0f)) + (double)f + bb.field_1321;
            if (side == class_2350.field_11033) {
                d1 = (double)j + bb.field_1322 - (double)f;
            }
            if (side == class_2350.field_11036) {
                d1 = (double)j + bb.field_1325 + (double)f;
            }
            if (side == class_2350.field_11043) {
                d2 = (double)k + bb.field_1321 - (double)f;
            }
            if (side == class_2350.field_11035) {
                d2 = (double)k + bb.field_1324 + (double)f;
            }
            if (side == class_2350.field_11039) {
                d0 = (double)i + bb.field_1323 - (double)f;
            }
            if (side == class_2350.field_11034) {
                d0 = (double)i + bb.field_1320 + (double)f;
            }
            class_703 fx = new class_727.class_728().method_3109(new class_2388(class_2398.field_11217, blockState), world, d0, d1, d2, 0.0, 0.0, 0.0);
            particleManager.method_3058(fx);
        }
    }

    @Override
    public Function<class_2960, class_1058> getBlockTextureGetter() {
        return TEXTURE_GETTER;
    }

    @Override
    public class_1058 getBlockIcon(class_2248 block) {
        return class_310.method_1551().method_1541().method_3351().method_3339(block.method_9564());
    }

    @Override
    public boolean isPointInRegion(int left, int top, int width, int height, double pointX, double pointY) {
        return pointX >= (double)left && pointX < (double)(left + width) && pointY >= (double)top && pointY < (double)(top + height);
    }

    @Override
    public boolean isPointInRegion(Rectangle region, Point point) {
        return this.isPointInRegion(region.x, region.y, region.width, region.height, point.x, point.y);
    }

    @Override
    public boolean isPointInButton(class_4185 button, int pointX, int pointY) {
        return this.isPointInRegion(button.method_46426(), button.method_46427(), button.method_25368(), button.method_25364(), pointX, pointY);
    }

    @Override
    public void blitColored(class_332 guiGraphics, class_2960 texture, int x, int y, float u, float v, int width, int height, float r, float g, float b, float a) {
        this.blitColored(guiGraphics, texture, x, y, u, v, width, height, 256, 256, r, g, b, a);
    }

    @Override
    public void blitColored(class_332 guiGraphics, class_2960 texture, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight, float r, float g, float b, float a) {
        int color = class_9848.method_61318((float)a, (float)r, (float)g, (float)b);
        guiGraphics.method_25291(class_10799.field_56883, texture, x, y, u, v, width, height, textureWidth, textureHeight, color);
    }
}

