/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.extendedconfig;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigurablePropertyCommon;
import org.cyclops.cyclopscore.config.ConfigurablePropertyData;
import org.cyclops.cyclopscore.config.ConfigurableTypeCommon;
import org.cyclops.cyclopscore.config.CyclopsCoreConfigException;
import org.cyclops.cyclopscore.init.IModBase;

public abstract class ExtendedConfigCommon<C extends ExtendedConfigCommon<C, I, M>, I, M extends IModBase>
implements Comparable<ExtendedConfigCommon<C, I, M>> {
    private final M mod;
    private final String namedId;
    private final Function<C, ? extends I> elementConstructor;
    private final List<Function<I, I>> instanceTransformers;
    private I instance;
    public Map<String, ConfigurablePropertyData<?>> configProperties = Maps.newHashMap();

    public ExtendedConfigCommon(M mod, String namedId, Function<C, ? extends I> elementConstructor) {
        this.mod = mod;
        this.namedId = namedId.toLowerCase(Locale.ROOT);
        this.elementConstructor = elementConstructor;
        this.instanceTransformers = new ArrayList<Function<I, I>>();
        try {
            mod.getConfigHandler().generateConfigProperties(this);
        }
        catch (IllegalAccessException | IllegalArgumentException e1) {
            e1.printStackTrace();
        }
    }

    public M getMod() {
        return this.mod;
    }

    public String getNamedId() {
        return this.namedId;
    }

    public Function<C, ? extends I> getElementConstructor() {
        return this.elementConstructor;
    }

    protected void initializeInstance() {
        I instance = this.getElementConstructor().apply(this.downCast());
        for (Function<I, I> instanceTransformer : this.instanceTransformers) {
            instance = instanceTransformer.apply(instance);
        }
        if (this.instance == null) {
            this.instance = instance;
        } else {
            this.showDoubleInitError();
        }
    }

    protected void save() {
        if (this.getConfigurableType().hasUniqueInstance()) {
            this.initializeInstance();
        }
    }

    public abstract ConfigurableTypeCommon getConfigurableType();

    public abstract String getTranslationKey();

    public String getFullTranslationKey() {
        return this.getTranslationKey();
    }

    public I getInstance() {
        if (!this.getConfigurableType().hasUniqueInstance()) {
            throw new IllegalStateException("Tried calling getInstance() on a config of type that has no unique instances.");
        }
        if (this.instance == null) {
            this.save();
        }
        return this.instance;
    }

    public String getSubUniqueName() {
        return this.getNamedId();
    }

    public void onRegistered() {
    }

    public void onForgeRegistered() {
    }

    @Override
    public int compareTo(ExtendedConfigCommon<C, I, M> o) {
        return this.getNamedId().compareTo(o.getNamedId());
    }

    public void showDoubleInitError() {
        String message = String.valueOf(this.getClass()) + " caused a double registration of " + String.valueOf(this.getInstance()) + ". This is an error in the mod code.";
        this.mod.log(Level.FATAL, message);
        throw new CyclopsCoreConfigException(message);
    }

    @Deprecated
    public C downCast() {
        return (C)this;
    }

    public void onConfigPropertyReload(ConfigurablePropertyData<?> configProperty, boolean reload) {
    }

    public String getConfigPropertyPrefix(ConfigurablePropertyCommon annotation) {
        return annotation.namedId().isEmpty() ? this.getNamedId() : annotation.namedId();
    }

    public void addInstanceTransformer(Function<I, I> transformer) {
        this.instanceTransformers.add(transformer);
    }
}

