/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

@Deprecated
public class CraftingHelpers {
    private static RecipeManager CLIENT_RECIPE_MANAGER;
    private static final LoadingCache<Triple<RecipeType<?>, CacheableCraftingInventory, ResourceLocation>, Optional<RecipeHolder<? extends Recipe>>> CACHE_RECIPES;

    public static void load() {
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, CraftingHelpers::onRecipesLoaded);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onRecipesLoaded(RecipesUpdatedEvent event) {
        CLIENT_RECIPE_MANAGER = event.getRecipeManager();
    }

    public static <C extends RecipeInput, T extends Recipe<C>> List<RecipeHolder<T>> findRecipes(Level world, RecipeType<? extends T> recipeType) {
        return world.isClientSide() ? CraftingHelpers.getClientRecipes(recipeType) : CraftingHelpers.findServerRecipes((ServerLevel)world, recipeType);
    }

    public static RecipeManager getRecipeManager() {
        return MinecraftHelpers.isClientSide() ? (CLIENT_RECIPE_MANAGER != null ? CLIENT_RECIPE_MANAGER : Minecraft.getInstance().getConnection().getRecipeManager()) : Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer().getLevel(Level.OVERWORLD), "Server is still loading").getRecipeManager();
    }

    public static <C extends RecipeInput, T extends Recipe<C>> Optional<RecipeHolder<T>> getServerRecipe(RecipeType<T> recipeType, ResourceLocation recipeName) {
        return Optional.ofNullable(CraftingHelpers.getRecipeManager().byKeyTyped(recipeType, recipeName));
    }

    public static <C extends RecipeInput, T extends Recipe<C>> Optional<RecipeHolder<T>> findServerRecipe(RecipeType<T> recipeType, C container, Level world) {
        return world.getRecipeManager().getRecipeFor(recipeType, container, world);
    }

    public static <C extends RecipeInput, T extends Recipe<C>> List<RecipeHolder<T>> findServerRecipes(RecipeType<? extends T> recipeType) {
        return CraftingHelpers.findServerRecipes(Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer().getLevel(Level.OVERWORLD)), recipeType);
    }

    public static <C extends RecipeInput, T extends Recipe<C>> List<RecipeHolder<T>> findServerRecipes(ServerLevel world, RecipeType<? extends T> recipeType) {
        return world.getRecipeManager().getAllRecipesFor(recipeType);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <C extends RecipeInput, T extends Recipe<C>> Optional<RecipeHolder<T>> getClientRecipe(RecipeType<T> recipeType, ResourceLocation recipeName) {
        return Optional.ofNullable(CraftingHelpers.getRecipeManager().byKeyTyped(recipeType, recipeName));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <C extends RecipeInput, T extends Recipe<C>> List<RecipeHolder<T>> getClientRecipes(RecipeType<? extends T> recipeType) {
        return CraftingHelpers.getRecipeManager().getAllRecipesFor(recipeType);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <C extends RecipeInput, T extends Recipe<C>> RecipeHolder<T> findClientRecipe(RegistryAccess registryAccess, ItemStack itemStack, RecipeType<T> recipeType, int index) throws IllegalArgumentException {
        int indexAttempt = index;
        for (RecipeHolder<T> recipe : CraftingHelpers.getClientRecipes(recipeType)) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)recipe.value().getResultItem((HolderLookup.Provider)registryAccess), (ItemStack)itemStack) || indexAttempt-- != 0) continue;
            return recipe;
        }
        throw new IllegalArgumentException("Could not find recipe for " + String.valueOf(itemStack) + "::" + String.valueOf(itemStack.getComponents()) + " with index " + index);
    }

    public static <C extends RecipeInput, T extends Recipe<C>> Optional<RecipeHolder<T>> findRecipeCached(RecipeType<T> recipeType, C inventoryCrafting, Level world, boolean uniqueInventory) {
        return (Optional)CACHE_RECIPES.getUnchecked((Object)Triple.of(recipeType, (Object)new CacheableCraftingInventory(inventoryCrafting, !uniqueInventory), (Object)world.dimension().location()));
    }

    static {
        CACHE_RECIPES = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build(new CacheLoader<Triple<RecipeType<?>, CacheableCraftingInventory, ResourceLocation>, Optional<RecipeHolder<? extends Recipe>>>(){

            public Optional<RecipeHolder<? extends Recipe>> load(Triple<RecipeType<?>, CacheableCraftingInventory, ResourceLocation> key) throws Exception {
                ServerLevel world = ServerLifecycleHooks.getCurrentServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)((ResourceLocation)key.getRight())));
                return world.getRecipeManager().getRecipeFor((RecipeType)key.getLeft(), ((CacheableCraftingInventory)key.getMiddle()).getInventoryCrafting(), (Level)world);
            }
        });
    }

    public static class CacheableCraftingInventory {
        private final RecipeInput inventoryCrafting;

        public CacheableCraftingInventory(RecipeInput inventoryCrafting, boolean copyInventory) {
            if (copyInventory) {
                int width = inventoryCrafting.size();
                int height = 1;
                if (inventoryCrafting instanceof CraftingInput) {
                    width = ((CraftingInput)inventoryCrafting).width();
                    height = ((CraftingInput)inventoryCrafting).height();
                }
                int size = inventoryCrafting.size();
                NonNullList items = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
                for (int i = 0; i < inventoryCrafting.size(); ++i) {
                    items.set(i, (Object)inventoryCrafting.getItem(i).copy());
                }
                this.inventoryCrafting = CraftingInput.of((int)width, (int)height, (List)items);
            } else {
                this.inventoryCrafting = inventoryCrafting;
            }
        }

        public RecipeInput getInventoryCrafting() {
            return this.inventoryCrafting;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof CacheableCraftingInventory)) {
                return false;
            }
            RecipeInput otherInput = ((CacheableCraftingInventory)obj).getInventoryCrafting();
            RecipeInput recipeInput = this.getInventoryCrafting();
            if (recipeInput instanceof CraftingInput) {
                CraftingInput craftingInputThis = (CraftingInput)recipeInput;
                if (!(otherInput instanceof CraftingInput)) return false;
                CraftingInput craftingInputOther = (CraftingInput)otherInput;
                if (craftingInputThis.width() != craftingInputOther.width() || craftingInputThis.height() != craftingInputOther.height()) {
                    return false;
                }
            } else if (this.getInventoryCrafting().size() != otherInput.size()) {
                return false;
            }
            for (int i = 0; i < this.getInventoryCrafting().size(); ++i) {
                if (ItemStack.isSameItemSameComponents((ItemStack)this.getInventoryCrafting().getItem(i), (ItemStack)otherInput.getItem(i))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hash = 11 + this.getInventoryCrafting().size();
            RecipeInput recipeInput = this.getInventoryCrafting();
            if (recipeInput instanceof CraftingInput) {
                CraftingInput craftingInput = (CraftingInput)recipeInput;
                hash = 23 + 3 * craftingInput.width() + 5 * craftingInput.height();
            }
            for (int i = 0; i < this.getInventoryCrafting().size(); ++i) {
                hash |= ItemStackHelpers.getItemStackHashCode(this.getInventoryCrafting().getItem(i)) * i;
            }
            return hash;
        }
    }
}

