/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.collection;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.ingredient.collection.FilteredIngredientMapIterator;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientMap;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientMapMutable;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollections;
import org.cyclops.cyclopscore.ingredient.collection.IngredientHashSet;
import org.cyclops.cyclopscore.ingredient.collection.IngredientSet;

public abstract class IngredientMapAdapter<T, M, V>
implements IIngredientMapMutable<T, M, V> {
    private final IngredientComponent<T, M> component;

    protected IngredientMapAdapter(IngredientComponent<T, M> component) {
        this.component = component;
    }

    @Override
    public IngredientComponent<T, M> getComponent() {
        return this.component;
    }

    @Override
    public int removeAll(T instance, M matchCondition) {
        Iterator<Map.Entry<T, V>> it = this.iterator(instance, matchCondition);
        int count = 0;
        while (it.hasNext()) {
            it.next();
            it.remove();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<Map.Entry<T, V>> iterator(T instance, M matchCondition) {
        if (Objects.equals(this.getComponent().getMatcher().getAnyMatchCondition(), matchCondition)) {
            return this.iterator();
        }
        return new FilteredIngredientMapIterator(this.iterator(), this.getComponent().getMatcher(), instance, matchCondition);
    }

    @Override
    public Collection<V> getAll(T key, M matchCondition) {
        if (Objects.equals(this.getComponent().getMatcher().getAnyMatchCondition(), matchCondition)) {
            return this.values();
        }
        IngredientSet<T, M> keys = this.keySet(key, matchCondition);
        ArrayList values = Lists.newArrayListWithCapacity((int)keys.size());
        for (Object instance : keys) {
            values.add(this.get(instance));
        }
        return values;
    }

    @Override
    public IngredientSet<T, M> keySet(T instance, M matchCondition) {
        if (Objects.equals(this.getComponent().getMatcher().getAnyMatchCondition(), matchCondition)) {
            return this.keySet();
        }
        IngredientHashSet filteredKeys = new IngredientHashSet(this.getComponent(), this.size());
        Iterator iterator = this.keySet().iterator(instance, matchCondition);
        while (iterator.hasNext()) {
            filteredKeys.add(iterator.next());
        }
        return filteredKeys;
    }

    @Override
    public Set<Map.Entry<T, V>> entrySet() {
        return Sets.newHashSet(this.iterator());
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof IIngredientMap && IngredientCollections.equalsMap(this, (IIngredientMap)obj);
    }

    @Override
    public int hashCode() {
        return IngredientCollections.hash(this);
    }

    @Override
    public String toString() {
        return IngredientCollections.toString(this);
    }
}

