/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory.slot;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;

public class SlotFluidContainer
extends Slot {
    @Nullable
    private final Fluid fluid;

    public SlotFluidContainer(Container inventory, int index, int x, int y, @Nullable Fluid fluid) {
        super(inventory, index, x, y);
        this.fluid = fluid;
    }

    public boolean mayPlace(ItemStack itemStack) {
        return SlotFluidContainer.checkIsItemValid(itemStack, this.fluid);
    }

    public static boolean checkIsItemValid(ItemStack itemStack, @Nullable Fluid fluid) {
        if (!itemStack.isEmpty()) {
            Optional fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack);
            return fluidHandler.map(h -> {
                if (fluid == null) {
                    return true;
                }
                for (int i = 0; i < h.getTanks(); ++i) {
                    if (!h.isFluidValid(0, new FluidStack(fluid, 1)) && !h.isFluidValid(0, new FluidStack(fluid, 1000))) continue;
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }
}

