/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.recipe.type;

import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidHandlerListReadOnly
implements IFluidHandler {
    private final NonNullList<FluidStack> fluidStacks;

    public FluidHandlerListReadOnly(NonNullList<FluidStack> fluidStacks) {
        this.fluidStacks = fluidStacks;
    }

    public int getTanks() {
        return this.fluidStacks.size();
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        if (tank >= this.getTanks()) {
            return FluidStack.EMPTY;
        }
        return (FluidStack)this.fluidStacks.get(tank);
    }

    public int getTankCapacity(int tank) {
        throw new UnsupportedOperationException("getTankCapacity is not implemented on FluidHandlerList");
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        throw new UnsupportedOperationException("isFluidValid is not implemented on FluidHandlerList");
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        throw new UnsupportedOperationException("fill is not implemented on FluidHandlerList");
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        throw new UnsupportedOperationException("drain is not implemented on FluidHandlerList");
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        throw new UnsupportedOperationException("drain is not implemented on FluidHandlerList");
    }
}

