/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.recipe.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import org.cyclops.cyclopscore.recipe.type.RecipeCraftingShapelessCustomOutput;

public class RecipeCraftingShapedCustomOutput
extends ShapedRecipe {
    private final Serializer serializer;
    private final ItemStack recipeOutput;
    private final ShapedRecipePattern shapedRecipePattern;

    public RecipeCraftingShapedCustomOutput(Serializer serializer, String groupIn, CraftingBookCategory category, ShapedRecipePattern shapedRecipePattern, ItemStack recipeOutputIn, boolean showNotification) {
        super(groupIn, category, shapedRecipePattern, recipeOutputIn, showNotification);
        this.serializer = serializer;
        this.recipeOutput = recipeOutputIn;
        this.shapedRecipePattern = shapedRecipePattern;
    }

    public RecipeSerializer<?> getSerializer() {
        return this.serializer;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registryAccess) {
        RecipeCraftingShapelessCustomOutput.Serializer.IOutputTransformer outputTransformer = this.serializer.getOutputTransformer();
        if (outputTransformer != null) {
            return outputTransformer.transform(inv, this.getResultItem());
        }
        return this.getResultItem().copy();
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return this.getResultItem();
    }

    public ItemStack getResultItem() {
        return this.recipeOutput;
    }

    public static class Serializer
    implements RecipeSerializer<RecipeCraftingShapedCustomOutput> {
        private final Supplier<ItemStack> outputProvider;
        @Nullable
        private final RecipeCraftingShapelessCustomOutput.Serializer.IOutputTransformer outputTransformer;
        public final MapCodec<RecipeCraftingShapedCustomOutput> codec;
        public final StreamCodec<RegistryFriendlyByteBuf, RecipeCraftingShapedCustomOutput> streamCodec;

        public Serializer(Supplier<ItemStack> outputProvider, @Nullable RecipeCraftingShapelessCustomOutput.Serializer.IOutputTransformer outputTransformer) {
            this.outputProvider = outputProvider;
            this.outputTransformer = outputTransformer;
            this.codec = RecordCodecBuilder.mapCodec(p_311728_ -> p_311728_.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(p_311729_ -> p_311729_.getGroup()), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(p_311732_ -> p_311732_.category()), (App)ShapedRecipePattern.MAP_CODEC.forGetter(p_311733_ -> p_311733_.shapedRecipePattern), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(p_311731_ -> p_311731_.showNotification())).apply((Applicative)p_311728_, (group, category, shapedRecipePattern, showNotification) -> new RecipeCraftingShapedCustomOutput(this, (String)group, (CraftingBookCategory)category, (ShapedRecipePattern)shapedRecipePattern, this.outputProvider.get(), (boolean)showNotification)));
            this.streamCodec = StreamCodec.of(this::toNetwork, this::fromNetwork);
        }

        public Serializer(Supplier<ItemStack> outputProvider) {
            this(outputProvider, null);
        }

        @Nullable
        public RecipeCraftingShapelessCustomOutput.Serializer.IOutputTransformer getOutputTransformer() {
            return this.outputTransformer;
        }

        public MapCodec<RecipeCraftingShapedCustomOutput> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, RecipeCraftingShapedCustomOutput> streamCodec() {
            return this.streamCodec;
        }

        private RecipeCraftingShapedCustomOutput fromNetwork(RegistryFriendlyByteBuf p_319998_) {
            String s = p_319998_.readUtf();
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)p_319998_.readEnum(CraftingBookCategory.class);
            ShapedRecipePattern shapedrecipepattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)p_319998_);
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)p_319998_);
            boolean flag = p_319998_.readBoolean();
            return new RecipeCraftingShapedCustomOutput(this, s, craftingbookcategory, shapedrecipepattern, itemstack, flag);
        }

        private void toNetwork(RegistryFriendlyByteBuf p_320738_, RecipeCraftingShapedCustomOutput p_320586_) {
            p_320738_.writeUtf(p_320586_.getGroup());
            p_320738_.writeEnum((Enum)p_320586_.category());
            ShapedRecipePattern.STREAM_CODEC.encode((Object)p_320738_, (Object)p_320586_.shapedRecipePattern);
            ItemStack.STREAM_CODEC.encode((Object)p_320738_, (Object)p_320586_.getResultItem());
            p_320738_.writeBoolean(p_320586_.showNotification());
        }
    }
}

