/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.block.multi;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_4538;
import org.cyclops.cyclopscore.algorithm.Dimension;
import org.cyclops.cyclopscore.block.multi.AllowedBlock;
import org.cyclops.cyclopscore.block.multi.DetectionResult;
import org.cyclops.cyclopscore.block.multi.IBlockCountValidator;
import org.cyclops.cyclopscore.block.multi.ISizeValidator;
import org.cyclops.cyclopscore.helper.ILocationHelpers;
import org.cyclops.cyclopscore.helper.IModHelpers;

public class CubeDetector {
    private static class_2382 NULL_SIZE = class_2382.field_11176;
    private Collection<AllowedBlock> allowedBlocks = Sets.newHashSet();
    private Map<class_2248, AllowedBlock> blockInfo = Maps.newHashMap();
    private List<? extends IDetectionListener> listeners;
    private List<ISizeValidator> sizeValidators = Lists.newLinkedList();
    private final Map<class_2248, Integer> blockOccurences = Maps.newHashMap();

    public CubeDetector(AllowedBlock[] allowedBlocks, List<? extends IDetectionListener> listeners) {
        this.addAllowedBlocks(allowedBlocks);
        this.listeners = listeners;
    }

    public Collection<AllowedBlock> getAllowedBlocks() {
        return this.allowedBlocks;
    }

    public void addAllowedBlocks(AllowedBlock[] allowedBlocks) {
        for (AllowedBlock block : allowedBlocks) {
            this.blockInfo.put(block.getBlock(), block);
            this.allowedBlocks.add(block);
        }
    }

    public List<ISizeValidator> getSizeValidators() {
        return this.sizeValidators;
    }

    public CubeDetector addSizeValidator(ISizeValidator sizeValidator) {
        this.sizeValidators.add(sizeValidator);
        return this;
    }

    public List<? extends IDetectionListener> getListeners() {
        return this.listeners;
    }

    protected void notifyListeners(class_4538 world, class_2338 location, class_2382 size, boolean valid, class_2338 originCorner) {
        for (IDetectionListener iDetectionListener : this.getListeners()) {
            iDetectionListener.onDetect(world, location, size, valid, originCorner);
        }
    }

    protected class_2561 isValidLocation(class_4538 world, class_2338 location, IValidationAction action, class_2338 excludeLocation) {
        class_2561 error;
        boolean contains;
        class_2680 blockState = world.method_8320(location);
        class_2248 block = blockState.method_26204();
        boolean bl = contains = location.equals((Object)excludeLocation) || this.blockInfo.containsKey(block);
        if (action != null && this.blockInfo.containsKey(block) && (error = action.onValidate(location, blockState)) != null) {
            return error;
        }
        return contains ? null : class_2561.method_43469((String)"multiblock.cyclopscore.error.invalidBlock", (Object[])new Object[]{IModHelpers.get().getLocationHelpers().toCompactString(location), class_2561.method_43471((String)block.method_9539())});
    }

    protected class_2561 isValidLocation(class_4538 world, class_2338 location, class_2338 excludeLocation) {
        return this.isValidLocation(world, location, null, excludeLocation);
    }

    protected boolean isAir(class_4538 world, class_2338 location) {
        return world.method_22347(location);
    }

    protected class_2338 navigateToBorder(class_4538 world, class_2338 startLocation, int dimension, int direction, class_2338 excludeLocation) {
        ILocationHelpers locationHelpers = IModHelpers.get().getLocationHelpers();
        class_2338 loopLocation = locationHelpers.copyLocation(startLocation);
        while (this.isValidLocation(world, loopLocation, excludeLocation) == null) {
            loopLocation = locationHelpers.addToDimension(loopLocation, dimension, direction);
        }
        loopLocation = locationHelpers.addToDimension(loopLocation, dimension, -direction);
        return loopLocation;
    }

    protected class_2338 navigateToBorder(class_4538 world, class_2338 startLocation, int dimension, boolean max, class_2338 excludeLocation) {
        return this.navigateToBorder(world, startLocation, dimension, max ? 1 : -1, excludeLocation);
    }

    protected class_2338 navigateToCorner(class_4538 world, class_2338 startLocation, int[] dimensions, boolean max, class_2338 excludeLocation) {
        class_2338 navigateLocation = IModHelpers.get().getLocationHelpers().copyLocation(startLocation);
        for (int dimension : dimensions) {
            navigateLocation = this.navigateToBorder(world, navigateLocation, dimension, max, excludeLocation);
        }
        return navigateLocation;
    }

    protected boolean isEdge(class_4538 world, int[][] dimensionEgdes, class_2338 location) {
        int[] c = IModHelpers.get().getLocationHelpers().toArray((class_2382)location);
        for (int i = 0; i < dimensionEgdes.length; ++i) {
            for (int j = 0; j < dimensionEgdes[i].length; ++j) {
                if (dimensionEgdes[i][j] != c[i]) continue;
                return true;
            }
        }
        return false;
    }

    protected class_2561 validateLocationInStructure(class_4538 world, int[][] dimensionEgdes, class_2338 location, IValidationAction action, class_2338 excludeLocation) {
        return this.isValidLocation(world, location, action, excludeLocation);
    }

    protected boolean coordinateRecursion(class_4538 world, int[][] dimensionEgdes, BlockPosAction locationAction) {
        return this.coordinateRecursion(world, dimensionEgdes, new int[0], locationAction);
    }

    protected boolean coordinateRecursion(class_4538 world, int[][] dimensionEgdes, int[] accumulatedCoordinates, BlockPosAction locationAction) {
        if (accumulatedCoordinates.length == dimensionEgdes.length) {
            class_2338 location = IModHelpers.get().getLocationHelpers().fromArray(accumulatedCoordinates);
            if (!locationAction.run(world, location)) {
                return false;
            }
        } else {
            int dimension = accumulatedCoordinates.length;
            int i = dimensionEgdes[dimension][0];
            while (i <= dimensionEgdes[dimension][1]) {
                int[] newAccumulatedCoordinates = Arrays.copyOf(accumulatedCoordinates, accumulatedCoordinates.length + 1);
                newAccumulatedCoordinates[accumulatedCoordinates.length] = i++;
                if (this.coordinateRecursion(world, dimensionEgdes, newAccumulatedCoordinates, locationAction)) continue;
                return false;
            }
        }
        return true;
    }

    protected class_2561 validateAllowedBlockConditions(class_4538 world, class_2338 location) {
        class_2248 block = world.method_8320(location).method_26204();
        if (this.blockInfo.containsKey(block)) {
            Integer occurences = this.blockOccurences.get(block);
            if (occurences == null) {
                occurences = 0;
            }
            AllowedBlock allowed = this.blockInfo.get(block);
            for (IBlockCountValidator validator : allowed.getCountValidators()) {
                class_2561 error = validator.isValid(occurences, false, allowed.getBlock());
                if (error == null) continue;
                return error;
            }
            this.blockOccurences.put(block, occurences + 1);
        }
        return null;
    }

    protected class_2561 validateDimensionEdges(class_4538 world, final int[][] dimensionEgdes, final boolean valid, final IValidationAction action, final class_2338 excludeLocation) {
        this.blockOccurences.clear();
        for (AllowedBlock block : this.allowedBlocks) {
            this.blockOccurences.put(block.getBlock(), 0);
        }
        final LinkedList errors = Lists.newLinkedList();
        boolean minimumValid = this.coordinateRecursion(world, dimensionEgdes, new BlockPosAction(){

            @Override
            public boolean run(class_4538 world, class_2338 location) {
                if (!valid) {
                    return true;
                }
                class_2561 allowedBlocks = CubeDetector.this.validateAllowedBlockConditions(world, location);
                class_2561 allowedLocation = CubeDetector.this.validateLocationInStructure(world, dimensionEgdes, location, action, excludeLocation);
                if (allowedBlocks != null) {
                    errors.add(allowedBlocks);
                }
                if (allowedLocation != null) {
                    errors.add(allowedLocation);
                }
                return allowedBlocks == null && allowedLocation == null;
            }
        });
        if (minimumValid) {
            for (AllowedBlock allowed : this.allowedBlocks) {
                int occurences = this.blockOccurences.getOrDefault(allowed.getBlock(), 0);
                for (IBlockCountValidator validator : allowed.getCountValidators()) {
                    class_2561 error = validator.isValid(occurences, true, allowed.getBlock());
                    if (error == null) continue;
                    return valid ? error : null;
                }
            }
        }
        return minimumValid ? null : (errors.isEmpty() ? null : (class_2561)errors.get(0));
    }

    protected void postValidate(class_4538 world, final class_2382 size, int[][] dimensionEgdes, final boolean valid, final class_2338 originCorner, class_2338 excludeLocation) {
        this.coordinateRecursion(world, dimensionEgdes, new BlockPosAction(){

            @Override
            public boolean run(class_4538 world, class_2338 location) {
                CubeDetector.this.notifyListeners(world, location, size, valid, originCorner);
                return true;
            }
        });
    }

    public DetectionResult detect(class_4538 world, class_2338 startLocation, class_2338 excludeLocation, boolean changeState) {
        return this.detect(world, startLocation, excludeLocation, null, changeState);
    }

    public DetectionResult detect(class_4538 world, class_2338 startLocation, class_2338 excludeLocation, IValidationAction action, boolean changeState) {
        ILocationHelpers locationHelpers = IModHelpers.get().getLocationHelpers();
        class_2561 error = this.isValidLocation(world, startLocation, excludeLocation);
        if (error != null) {
            return new DetectionResult(error);
        }
        class_2338 tempOriginCorner = this.navigateToCorner(world, startLocation, new int[]{2, 1, 0}, true, excludeLocation);
        class_2338 originCorner = this.navigateToCorner(world, tempOriginCorner, new int[]{0, 1, 2}, false, excludeLocation);
        class_2338[] corners = new class_2338[Dimension.DIMENSIONS.length];
        for (int i = 0; i < corners.length; ++i) {
            corners[i] = this.navigateToCorner(world, originCorner, new int[]{i}, true, excludeLocation);
        }
        int[] distances = new int[corners.length];
        int[][] dimensionEgdes = new int[corners.length][2];
        int[] cOriginCorner = locationHelpers.toArray((class_2382)originCorner);
        for (int i = 0; i < corners.length; ++i) {
            int[] cCorner = locationHelpers.toArray((class_2382)corners[i]);
            class_2338 sizeDifference = locationHelpers.subtract(corners[i], (class_2382)originCorner);
            distances[i] = locationHelpers.toArray((class_2382)sizeDifference)[i];
            int addIndex = 0;
            if (cOriginCorner[i] > cCorner[i]) {
                addIndex = 1;
            }
            dimensionEgdes[i][(0 + addIndex) % 2] = cOriginCorner[i];
            dimensionEgdes[i][(1 + addIndex) % 2] = cCorner[i];
        }
        error = this.validateDimensionEdges(world, dimensionEgdes, excludeLocation == null, action, excludeLocation);
        if (error != null) {
            return new DetectionResult(error);
        }
        class_2338 size = locationHelpers.fromArray(distances);
        for (ISizeValidator validator : this.getSizeValidators()) {
            error = validator.isSizeValid((class_2382)size);
            if (error == null || excludeLocation != null) continue;
            return new DetectionResult(error);
        }
        if (changeState) {
            this.postValidate(world, (class_2382)size, dimensionEgdes, excludeLocation == null, originCorner, excludeLocation);
        }
        return new DetectionResult((class_2382)size);
    }

    public static interface IDetectionListener {
        public void onDetect(class_4538 var1, class_2338 var2, class_2382 var3, boolean var4, class_2338 var5);
    }

    public static interface IValidationAction {
        public class_2561 onValidate(class_2338 var1, class_2680 var2);
    }

    protected static interface BlockPosAction {
        public boolean run(class_4538 var1, class_2338 var2);
    }
}

