/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.component.input;

import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonArrow;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;

public class WidgetNumberField
extends WidgetTextFieldExtended {
    private final boolean arrows;
    private ButtonArrow arrowUp;
    private ButtonArrow arrowDown;
    private int minValue = Integer.MIN_VALUE;
    private int maxValue = Integer.MAX_VALUE;
    private boolean isEnabled = true;

    public WidgetNumberField(class_327 fontrenderer, int x, int y, int width, int height, boolean arrows, class_2561 narrationMessage, boolean background) {
        super(fontrenderer, x, y, width, height, narrationMessage, background);
        this.arrows = arrows;
        if (this.arrows) {
            this.arrowUp = new ButtonArrow(x, y + height / 2, (class_2561)class_2561.method_43471((String)"gui.cyclopscore.up"), button -> this.increase(), ButtonArrow.Direction.NORTH);
            this.arrowDown = new ButtonArrow(x, y + height / 2, (class_2561)class_2561.method_43471((String)"gui.cyclopscore.down"), button -> this.decrease(), ButtonArrow.Direction.SOUTH);
            this.arrowUp.method_46419(this.arrowUp.method_46427() - this.arrowUp.method_25364());
        }
        this.method_1858(true);
        this.method_1852("0");
    }

    public void method_1888(boolean enabled) {
        this.arrowUp.field_22763 = enabled;
        this.arrowDown.field_22763 = enabled;
        this.isEnabled = enabled;
        super.method_1888(enabled);
    }

    public boolean method_1851() {
        return false;
    }

    public void setPositiveOnly(boolean positiveOnly) {
        this.setMinValue(positiveOnly ? 0 : Integer.MIN_VALUE);
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
        this.updateArrowsState();
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public int getInt() throws NumberFormatException {
        return this.validateNumber(Integer.parseInt(this.method_1882()));
    }

    public double getDouble() throws NumberFormatException {
        return this.validateNumber(Double.parseDouble(this.method_1882()));
    }

    public float getFloat() throws NumberFormatException {
        return this.validateNumber(Float.parseFloat(this.method_1882()));
    }

    @Override
    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int offsetX = 0;
        if (this.arrows) {
            this.arrowUp.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
            this.arrowDown.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
            offsetX = this.arrowUp.method_25368();
            this.method_46421(this.method_46426() + offsetX);
            this.field_22758 -= offsetX;
        }
        super.method_48579(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.arrows) {
            this.method_46421(this.method_46426() - offsetX);
            this.field_22758 += offsetX;
        }
    }

    public int validateNumber(int number) {
        return Math.max(this.minValue, Math.min(this.maxValue, number));
    }

    public double validateNumber(double number) {
        return Math.max((double)this.minValue, Math.min((double)this.maxValue, number));
    }

    public float validateNumber(float number) {
        return Math.max((float)this.minValue, Math.min((float)this.maxValue, number));
    }

    protected int getDiffAmount() {
        return class_437.method_25442() ? 10 : 1;
    }

    protected void increase() {
        try {
            this.method_1852(Integer.toString(this.validateNumber(this.getInt() + this.getDiffAmount())));
        }
        catch (NumberFormatException e) {
            this.method_1852("0");
        }
        this.updateArrowsState();
    }

    protected void decrease() {
        try {
            this.method_1852(Integer.toString(this.validateNumber(this.getInt() - this.getDiffAmount())));
        }
        catch (NumberFormatException e) {
            this.method_1852("0");
        }
        this.updateArrowsState();
    }

    @Override
    public void method_1852(String value) {
        super.method_1852(value);
        this.updateArrowsState();
    }

    public boolean method_25400(char typedChar, int keyCode) {
        boolean ret = super.method_25400(typedChar, keyCode);
        this.updateArrowsState();
        return ret;
    }

    public boolean method_25404(int typedChar, int keyCode, int modifiers) {
        boolean ret = super.method_25404(typedChar, keyCode, modifiers);
        this.updateArrowsState();
        return ret;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        boolean ret = this.arrowUp.method_25402(mouseX, mouseY, mouseButton) || this.arrowDown.method_25402(mouseX, mouseY, mouseButton) || super.method_25402(mouseX, mouseY, mouseButton);
        this.updateArrowsState();
        return ret;
    }

    protected void updateArrowsState() {
        if (this.arrows) {
            this.arrowDown.field_22763 = true;
            this.arrowUp.field_22763 = true;
            try {
                if (this.getInt() <= this.minValue) {
                    this.arrowDown.field_22763 = false;
                }
                if (this.getInt() >= this.maxValue) {
                    this.arrowUp.field_22763 = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

