/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.command.argument;

import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2314;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_7157;

public class ArgumentTypeEnum<T extends Enum<T>>
implements ArgumentType<T> {
    private final Class<T> enumClass;

    public ArgumentTypeEnum(Class<T> enumClass) {
        this.enumClass = enumClass;
    }

    public T parse(StringReader reader) throws CommandSyntaxException {
        try {
            return Enum.valueOf(this.enumClass, reader.readString().toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Unknown value")).create();
        }
    }

    public Collection<String> getExamples() {
        return Arrays.stream((Enum[])this.enumClass.getEnumConstants()).map(Enum::name).map(name -> name.toLowerCase(Locale.ENGLISH)).collect(Collectors.toList());
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9265(this.getExamples(), (SuggestionsBuilder)builder);
    }

    public static <T extends Enum<T>> T getValue(CommandContext<class_2168> context, String name, Class<T> enumClass) {
        return (T)((Enum)context.getArgument(name, enumClass));
    }

    public static class Info
    implements class_2314<ArgumentTypeEnum<?>, Template<?>> {
        public void serializeToNetwork(Template<?> argumentTypeEnum, class_2540 packetBuffer) {
            packetBuffer.method_10814(argumentTypeEnum.enumClass.getName());
        }

        public Template deserializeFromNetwork(class_2540 packetBuffer) {
            try {
                return new Template(Class.forName(packetBuffer.method_19772()));
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public void serializeToJson(Template<?> argumentTypeEnum, JsonObject jsonObject) {
            jsonObject.addProperty("class", argumentTypeEnum.enumClass.getName());
        }

        public Template<?> unpack(ArgumentTypeEnum<?> arg) {
            return new Template(arg.enumClass);
        }

        public final class Template<T extends Enum<T>>
        implements class_2314.class_7217<ArgumentTypeEnum<?>> {
            private final Class<T> enumClass;

            Template(Class<T> enumClass) {
                this.enumClass = enumClass;
            }

            public ArgumentTypeEnum<?> instantiate(class_7157 p_235533_) {
                return new ArgumentTypeEnum<T>(this.enumClass);
            }

            public class_2314<ArgumentTypeEnum<?>, ?> method_41728() {
                return Info.this;
            }
        }
    }
}

